/* mando_no_radar.sqf v1.0 by Mandoble 2008

   Blocks the radar of any vehicle which type is in the provided array

   mando_no_radar title must be defined in mission description.ext file.

   Usage:
   [array of vehicle types with radar blocked, type]execVM"mando_no_radar.sqf"
   type = 0 -> cutRsc
   type = 1 -> titleRsc

   Example:
   [["M1Abrams", "Vulcan", "Vulcan_RACS"], 0]execVM"mando_no_radar.sqf"


   You may set mando_no_radar_active global var to false at any time to have radar enabled again. Set it to true to disable it.

   Note that this script has no effect over AI.
*/

private ["_veh", "_has_radar"];
mando_no_radar_active = true;
Sleep 1;
while {true} do
{
   _veh = vehicle player;

   if (typeOf _veh in (_this select 0)) then
   {
      while {(vehicle player == _veh) && mando_no_radar_active} do
      {
         if ((_this select 1) == 0) then
         {
            cutRsc["mando_no_radar", "PLAIN"];
         }
         else
         {
            titleRsc["mando_no_radar", "PLAIN"];
         };
         Sleep 1; 
      }; 

      if ((_this select 1) == 0) then
      {
         cutText["", "PLAIN"];  
      }
      else
      {
         titleText["", "PLAIN"];  
      };
   };
   Sleep 2;
};

