// ===========================================================================
//AASDialogs.hpp
//ArMoGaDoN  -  this is part of AAS v2
#define FontM "tahomaB"
#define FontHTML "Zeppelin32"

#define ST_LEFT       0
#define ST_RIGHT      1
#define ST_CENTER     2
#define ST_FRAME      64

#define CT_STATIC     0
#define CT_BUTTON	  1
#define CT_EDIT       2
#define CT_COMBO      4
#define CT_LISTBOX    5
#define CT_ACTIVETEXT 11
#define ST_PICTURE 48

class RscText
{
        type = CT_STATIC;
        idc = -1;
        style = ST_LEFT;
        colorBackground[] = {0, 0, 0, 0};
        colorText[] = {1, 1, 1, 1};
        font = FontM;
        sizeEx = 0.04;
};

class RscActiveText
{
	type = CT_ACTIVETEXT;
	idc = -1;
	style = ST_LEFT;
        color[] = {1, 1, 1, 1};
        colorActive[] = {1, 0, 0, 1};
        font = FontM;
        sizeEx = 0.04;
        soundEnter[] = {"ui\ui_over", 0.2, 1};
        soundPush[] = {, 0.2, 1};
        soundClick[] = {"ui\ui_ok", 0.2, 1};
        soundEscape[] = {"ui\ui_cc", 0.2, 1};
        default = false;
};

class RscButton
{
        type = CT_BUTTON;
        idc = -1;
        style = ST_CENTER;
        colorText[] = {0, 0, 0, 1};
        colorDisabled[] = {0.52, 0.32, 0.32, 1};
        colorBackground[] = {0.64, 0.64, 0.64, 1};
        colorBackgroundActive[] = {0.64, 0.64, 0.64, 1};
        colorBackgroundDisabled[] = {0.52, 0.52, 0.52, 1};
        colorFocused[] = {0.96, 0.64, 0.64, 1};
        colorShadow[] = {0.28, 0.28, 0.28, 1};
        colorBorder[] = {0.32, 0.32, 0.32, 1};
        borderSize=0;
  	offsetX=0;
  	offsetY=0;
  	offsetPressedX=2;
  	offsetPressedY=2;
        font = FontHTML;
        sizeEx = 0.025;
        soundPush[] = {, 0.2, 1};
        soundEnter[] = {, 0.2, 1};
        soundClick[] = {"ui\ui_ok", 0.2, 1};
        soundEscape[] = {"ui\ui_cc", 0.2, 1};
        default = false;
};

class RscEdit
{
       type = CT_EDIT;
       idc = -1;
       style = ST_LEFT;
       font = FontHTML;
       sizeEx = 0.02;
       colorText[] = {0, 0, 0, 1};
       colorSelection[] = {0.5, 0.5, 0.5, 1};
       autocomplete = false;
       text = ;
};

class RscLB_C
{
        style = ST_LEFT;
        idc = -1;
        colorSelect[] = {0.99, 0.99, 0.99, 1};
        colorSelectBackground[] = {0.96, 0.64, 0.64, 1};
        colorText[] = {0.1, 0.1, 0.1, 1};
        colorBackground[] = {0.64, 0.64, 0.64, 1};
        soundSelect[] = {"ui\ui_ok", 0.2, 1};
        soundExpand[] = {, 0.2, 1};
        soundCollapse[] = {, 0.2, 1};
        font = FontHTML;
        sizeEx = 0.025;
        rowHeight = 0.04;
};

class RscListBox : RscLB_C
{
        type = CT_LISTBOX;
};

class RscCombo : RscLB_C
{
        type = CT_COMBO;
        wholeHeight = 0.3;
};

class RscTitles
{	class AASLOGO1
	{	idd=-1;	movingEnable=false;
		duration=120;
		name="AASLOGO"; controls[]={"Pic1"};
		class Pic1
		{	type = CT_STATIC; idc = -1;
			x = 0;
			y = 0;
			w = 1;
			h = 1;
			text = "AAS_GENERIC.paa";
			style = ST_PICTURE; font = "TahomaB"; lineSpacing = 1.0;
			colorText[] = {1, 1, 1, 1}; colorBackground[] = {0, 0, 0, 0.45};
			size = 1; sizeEx = 1;
	};	};

	class AASSPLASH
	{	idd=-1;	movingEnable=false;
		duration=10;
		name="AASSPLASH"; controls[]={"Pic2"};
		class Pic2
		{	type = CT_STATIC; idc = -1;
			x = 0.25;
			y = 0.35;
			w = 0.5;
			h = 0.3;
			text = "AAS_SPLASH.paa";
			style = ST_PICTURE; font = "TahomaB"; lineSpacing = 1.0;
			colorText[] = {1, 1, 1, 1}; colorBackground[] = {0, 0, 0, 0.45};
			size = 1; sizeEx = 1;
	};	};
};

class DlgRespawn
{
  idd = -1;
  movingEnable = true;
  controlsBackground[] = { MY_BACKGROUND, MY_FRAME };
  class MY_BACKGROUND : RscText
  {
	colorBackground[] = {0.4, 0.4, 0.4, 1.00};
	text = ;
	x = 0.2;
	y = 0.6;
	w = 0.6;
	h = 0.2;
  };
  class MY_FRAME : RscText
  {
	idc = 101;
	style = ST_FRAME;
	colorText[] = {0, 0, 0, 1};
	text = "CHOOSE SPAWN LOCATION";
	font = FontHTML;
	sizeEx = 0.025;
	x = 0.22;
	y = 0.62;
	w = 0.56;
	h = 0.16;
  };
  objects[] = { };
  controls[] = {MY_LIST,MY_BUTTON};
  class MY_LIST : RscCombo
  {
	idc = 102;
	x = 0.29;
	y = 0.66;
	w = 0.42;
	h = 0.04;
  };
  class MY_BUTTON : RscButton
  {
	idc = 103;
	x = 0.39;
	y = 0.72;
	w = 0.2;
	h = 0.04;
	text = "SELECT";
	action = "[lbData[102, lbCurSel 102]] exec ""ArMo\AAS\doPlayerRespawn.sqs""; closeDialog 0;";
  };
};

class CfgMusic
{
   tracks[]={AASTrackIntro,AASTrackEnd};
   class AASTrackIntro
      {
        name = "AASTrackIntro";
        sound[] = {TrackIntro.ogg, db+0, 1.0};
      };
   class AASTrackEnd
      {
        name = "AASTrackEnd";
        sound[] = {TrackEnd.ogg, db+2, 1.0};
      };
};
// ===========================================================================
