// F2 - ShackTactical Assign Gear Script
// Credits: Please see the F2 online manual (http://www.ferstaberinde.com/f2/en/)
// ====================================================================================

// DECLARE VARIABLES AND FUNCTIONS

private [
"_faction","_rifle","_rifleGL","_MG","_pistol","_riflemag",
"_GLMag","_MGmag","_grenade","_at","_atmag",
"_smokewhite","_smokegreen","_smokered","_smokegrenade",
"_pistol","_pistolmag",
"_medicrifle","_medicmag","_snrifle","_snmag","_sprifle","_spmag","_mediumMG","_mediumMGmag",
"_mediumAT","_mediumATmag1","_mediumATmag2","_heavyAT","_heavyATmag1","_heavyATmag2"];

// ====================================================================================

// ERROR CHECKING
// If the script has been called without both required paramaters being passed, it 
// exits immediately.

sleep .1;

if (isNull (_this select 1)) exitwith {};
if (!local (_this select 1)) exitwith {};

// ====================================================================================

// GET UNIT FACTION
// The second variable passed to the script identifies the unit, from which we can
// then get the faction. More error checking is included here.

_typeofUnit = toLower (_this select 0);
_unit = _this select 1;
_faction = toLower (faction _unit);

if (isnil ("_faction")) then {call compile format ["_faction = '%1'",(faction _unit)];};
_faction =  tolower _faction;
if (!(_faction == "ru") and !(_faction == "usmc") and !(_faction == "gue") and !(_faction == "ins") and !(_faction == "cdf")) exitwith {player globalchat format ["DEBUG (f\common\@ShackTac_assignGear.sqf): Unit %1 faction %2 is not correct. Make sure the script is initialized correctly.",_unit,_faction];};

// ====================================================================================

// DEFINE FACTION EQUIPMENT
// The following blocks of code define the equipment for each faction.

switch (_faction) do
{

// ====================================================================================

// EQUIPMENT: RUSSIAN
// The block of code below identifies equipment for the Russian faction.

   case "ru":
   {
   _rifle = "AK_107_kobra";
   _rifleGL = "AK_107_GL_kobra";
   _medicrifle = "AK_74";
   _medicmag = "30Rnd_545x39_AK";
   _MG = "RPK_74";
   _riflemag = "30Rnd_545x39_AK";
   _GLmag = "1Rnd_HE_GP25";
   _MGmag = "75Rnd_545x39_RPK";
   _grenade = "HandGrenade_East";
   _at = "RPG18";
   _atmag = "RPG18";

   _snrifle = "SVD_CAMO";
   _snmag = "10Rnd_762x54_SVD";
   _sprifle = "AK_107_pso";
   _spmag = "30Rnd_545x39_AK";

   _mediumMG = "PK";
   _mediumMGmag = "100Rnd_762x54_PK";


   _mediumAT = "RPG7V";
   _mediumATmag1 = "PG7V";
   _mediumATmag2 = "PG7VR";

   _heavyAT = "MetisLauncher";
   _heavyATmag1 = "AT13";
   _heavyATmag2 = "AT13";

   _smokewhite = "1Rnd_SMOKE_GP25";
   _smokegreen = "1Rnd_SMOKEGREEN_GP25";
   _smokered = "1Rnd_SMOKERED_GP25";
   _smokegrenade = "SmokeShell";

   _pistol = "Makarov";
   _pistolmag = "8Rnd_9x18_Makarov";
   };

// ====================================================================================

// EQUIPMENT: USMC
// The block of code below identifies equipment for the USMC faction.

   case "usmc":
   {
   _rifle = "M16A4";
   _rifleGL = "M4A1_HWS_GL";
   _medicrifle = "M16A4";
   _medicmag = "30Rnd_556x45_Stanag";
   _MG = "M249";
   _riflemag = "30Rnd_556x45_Stanag";
   _GLmag = "1Rnd_HE_M203";
   _MGmag = "200Rnd_556x45_M249";
   _grenade = "HandGrenade_West";
   _at = "M136"; 
   _atmag = "M136";

   _snrifle = "M40A3";
   _snmag = "5Rnd_762x51_M24";
   _sprifle = "M16A4_ACG";
   _spmag = "30Rnd_556x45_Stanag";
 
   _mediumMG = "M240";
   _mediumMGmag = "100Rnd_762x51_M240";
 
   _mediumAT = "SMAW";
   _mediumATmag1 = "SMAW_HEAA";
   _mediumATmag2 = "SMAW_HEDP";

   _heavyAT = "Javelin";
   _heavyATmag1 = "Javelin";
   _heavyATmag2 = "Javelin";

   _smokewhite = "1Rnd_Smoke_M203";
   _smokegreen = "1Rnd_SmokeGreen_M203";
   _smokered = "1Rnd_SmokeRed_M203";
   _smokegrenade = "SmokeShell";
   
   _pistol = "M9";
   _pistolmag = "15Rnd_9x19_M9";
 
   };

// ====================================================================================

// EQUIPMENT: NAPA
// The block of code below identifies equipment for the NAPA faction.

   case "gue":
   {
   _rifle = "AK_74";
   _rifleGL = "AK_74_GL";
   _medicrifle = "AKS_74_U";
   _medicmag = "30Rnd_545x39_AK";
   _MG = "RPK_74";
   _riflemag = "30Rnd_545x39_AK";
   _GLmag = "1Rnd_HE_GP25";
   _MGmag = "75Rnd_545x39_RPK";
   _grenade = "HandGrenade_East";
   _at = "RPG18";
   _atmag = "RPG18";

   _snrifle = "Huntingrifle";
   _snmag = "5x_22_LR_17_HMR";
   _sprifle = "AKS_74_pso";
   _spmag = "30Rnd_545x39_AK";

   _mediumMG = "PK";
   _mediumMGmag = "100Rnd_762x54_PK";

   _mediumAT = "RPG7V";
   _mediumATmag1 = "PG7V";
   _mediumATmag2 = "PG7VR";

   _heavyAT = "MetisLauncher";
   _heavyATmag1 = "AT13";
   _heavyATmag2 = "AT13";

   _smokewhite = "1Rnd_SMOKE_GP25";
   _smokegreen = "1Rnd_SMOKEGREEN_GP25";
   _smokered = "1Rnd_SMOKERED_GP25";
   _smokegrenade = "SmokeShell";

   _pistol = "Makarov";
   _pistolmag = "8Rnd_9x18_Makarov";
   };

// ====================================================================================

// EQUIPMENT: CDF
// The block of code below identifies equipment for the CDF faction.

   case "cdf":
   {
   _rifle = "AK_74";
   _rifleGL = "AK_74_GL";
   _medicrifle = "AKS_74_U";
   _medicmag = "30Rnd_545x39_AK";
   _MG = "RPK_74";
   _riflemag = "30Rnd_545x39_AK";
   _GLmag = "1Rnd_HE_GP25";
   _MGmag = "75Rnd_545x39_RPK";
   _grenade = "HandGrenade_East";
   _at = "RPG18";
   _atmag = "RPG18";

   _snrifle = "SVD";
   _snmag = "10Rnd_762x54_SVD";
   _sprifle = "AKS_74_pso";
   _spmag = "30Rnd_545x39_AK";

   _mediumMG = "PK";
   _mediumMGmag = "100Rnd_762x54_PK";

   _mediumAT = "RPG7V";
   _mediumATmag1 = "PG7V";
   _mediumATmag2 = "PG7VR";

   _heavyAT = "MetisLauncher";
   _heavyATmag1 = "AT13";
   _heavyATmag2 = "AT13";

   _smokewhite = "1Rnd_SMOKE_GP25";
   _smokegreen = "1Rnd_SMOKEGREEN_GP25";
   _smokered = "1Rnd_SMOKERED_GP25";
   _smokegrenade = "SmokeShell";

   _pistol = "Makarov";
   _pistolmag = "8Rnd_9x18_Makarov";
   };

// ====================================================================================

// EQUIPMENT: CHDKZ
// The block of code below identifies equipment for the ChDKZ faction.

   case "ins":
   {
   _rifle = "AK_74";
   _rifleGL = "AK_74_GL";
   _medicrifle = "AKS_74_U";
   _medicmag = "30Rnd_545x39_AK";
   _MG = "RPK_74";
   _riflemag = "30Rnd_545x39_AK";
   _GLmag = "1Rnd_HE_GP25";
   _MGmag = "75Rnd_545x39_RPK";
   _grenade = "HandGrenade_East";
   _at = "RPG18";
   _atmag = "RPG18";

   _snrifle = "SVD";
   _snmag = "10Rnd_762x54_SVD";
   _sprifle = "AKS_74_pso";
   _spmag = "30Rnd_545x39_AK";

   _mediumMG = "PK";
   _mediumMGmag = "100Rnd_762x54_PK";

   _mediumAT = "RPG7V";
   _mediumATmag1 = "PG7V";
   _mediumATmag2 = "PG7VR";

   _heavyAT = "MetisLauncher";
   _heavyATmag1 = "AT13";
   _heavyATmag2 = "AT13";

   _smokewhite = "1Rnd_SMOKE_GP25";
   _smokegreen = "1Rnd_SMOKEGREEN_GP25";
   _smokered = "1Rnd_SMOKERED_GP25";
   _smokegrenade = "SmokeShell";

   _pistol = "Makarov";
   _pistolmag = "8Rnd_9x18_Makarov";
   };

};

// ====================================================================================

// DEFINE UNIT TYPE LOADOUTS
// The following blocks of code define loadouts for each type of unit (the unit type
// is passed to the script in the first variable).

switch (_typeofUnit) do
{

// ====================================================================================

// LOADOUT: PLATOON COMMANDER

   case "pltco":
   {
      removeallweapons _unit;
      {_unit addmagazine _riflemag} foreach [1,2,3,4,5,6,7];
      {_unit addmagazine _GLmag} foreach [1,2,3,4];
      {_unit addmagazine _smokewhite} foreach [1,2];
      {_unit addmagazine _grenade} foreach [1,2];
      _unit addmagazine _smokered;
      _unit addmagazine _smokegreen;
      _unit addmagazine _smokegrenade;
      _unit addweapon _rifleGL;
      _unit addweapon "NVGoggles";   
      _unit addweapon "Binocular";
      _unit selectweapon primaryweapon _unit;
   };

// ====================================================================================

// LOADOUT: PLATOON SGT.

   case "pltsgt":
   {
      removeallweapons _unit;
      {_unit addmagazine _riflemag} foreach [1,2,3,4,5,6,7];
      {_unit addmagazine _GLmag} foreach [1,2,3,4];
      {_unit addmagazine _smokewhite} foreach [1,2];
      {_unit addmagazine _grenade} foreach [1,2];
      _unit addmagazine _smokered;
      _unit addmagazine _smokegreen;
      _unit addmagazine _smokegrenade;
      _unit addweapon _rifleGL;
      _unit addweapon "NVGoggles";   
      _unit addweapon "Binocular";
      _unit selectweapon primaryweapon _unit;
   };

// ====================================================================================

// LOADOUT: PLATOON HQ SECTION RIFLEMAN

   case "pltr":
   {
      removeallweapons _unit;
      {_unit addmagazine _riflemag} foreach [1,2,3,4,5,6,7];
      {_unit addmagazine _grenade} foreach [1,2];
      _unit addweapon _rifle;
      _unit addweapon "NVGoggles";
      _unit selectweapon primaryweapon _unit;
   };

// ====================================================================================

// LOADOUT: PLATOON MEDIC

   case "pltm":
   {
      removeallweapons _unit;
      {_unit addmagazine _medicmag} foreach [1,2,3,4,5];
      _unit addweapon _medicrifle;
      _unit addweapon "NVGoggles";   
      {_unit addmagazine _smokegrenade;} foreach [1,2];
      _unit selectweapon primaryweapon _unit;
   };

// ====================================================================================

// LOADOUT: SQUAD LEADER

   case "sl":
   {
      removeallweapons _unit;
      {_unit addmagazine _riflemag} foreach [1,2,3,4,5,6,7];
      {_unit addmagazine _GLmag} foreach [1,2,3,4];
      {_unit addmagazine _smokewhite} foreach [1,2];
      {_unit addmagazine _grenade} foreach [1,2];
      _unit addmagazine _smokered;
      _unit addmagazine _smokegreen;
      {_unit addmagazine _smokegrenade;} foreach [1,2];
      _unit addweapon _rifleGL;
      _unit addweapon "NVGoggles";   
      _unit addweapon "Binocular";
      _unit selectweapon primaryweapon _unit;
   };

// ====================================================================================

// LOADOUT: MEDIC

   case "m":
   {
      removeallweapons _unit;
      {_unit addmagazine _medicmag} foreach [1,2,3,4,5];
      _unit addweapon _medicrifle;
      _unit addweapon _rucksack;
      _unit addweapon "NVGoggles";   
      {_unit addmagazine _smokegrenade;} foreach [1,2];
      _unit selectweapon primaryweapon _unit;
   };

// ====================================================================================

// LOADOUT: FIRE TEAM LEADER

   case "ftl":
   {
      removeallweapons _unit;
      {_unit addmagazine _riflemag} foreach [1,2,3,4,5,6,7];
      {_unit addmagazine _GLmag} foreach [1,2,3,4,5];
      {_unit addmagazine _smokewhite} foreach [1];
      {_unit addmagazine _Grenade} foreach [1,2];
      {_unit addmagazine _smokegrenade;} foreach [1,2];
      _unit addweapon _rifleGL;
      _unit addweapon "NVGoggles";   
      _unit addweapon "Binocular";
      _unit selectweapon primaryweapon _unit;
   };

// ====================================================================================

// LOADOUT: AUTOMATIC RIFLEMAN
// The loadouts differ slightly for each faction.

   case "ar":
   {
      switch (_faction) do
      {
   	case "ru":
   	{
	      removeallweapons _unit;
	      {_unit addmagazine _MGmag;} foreach [1,2,3,4,5];
	      _unit addweapon _MG;
	      {_unit addmagazine _pistolmag;} foreach [1,2];
	      _unit addweapon _pistol;
	      _unit addweapon "NVGoggles";
	      _unit selectweapon primaryweapon _unit;
	};
	case "usmc":
	{
	      removeallweapons _unit;
	      {_unit addmagazine _MGmag;} foreach [1,2];
	      _unit addweapon _MG;
	      {_unit addmagazine _pistolmag;} foreach [1,2];
	      _unit addweapon _pistol;
	      _unit addweapon "NVGoggles";
	      _unit selectweapon primaryweapon _unit;
	};
	case "gue":
	{
	      removeallweapons _unit;
	      {_unit addmagazine _MGmag;} foreach [1,2,3,4,5];
	      _unit addweapon _MG;
	      {_unit addmagazine _pistolmag;} foreach [1,2];
	      _unit addweapon _pistol;
	      _unit addweapon "NVGoggles";
	      _unit selectweapon primaryweapon _unit;
	};
	case "ins":
	{
	      removeallweapons _unit;
	      {_unit addmagazine _MGmag;} foreach [1,2,3,4,5];
	      _unit addweapon _MG;
	      {_unit addmagazine _pistolmag;} foreach [1,2];
	      _unit addweapon _pistol;
	      _unit addweapon "NVGoggles";
	      _unit selectweapon primaryweapon _unit;
	};
	case "cdf":
	{
	      removeallweapons _unit;
	      {_unit addmagazine _MGmag;} foreach [1,2,3,4,5];
	      _unit addweapon _MG;
	      {_unit addmagazine _pistolmag;} foreach [1,2];
	      _unit addweapon _pistol;
	      _unit addweapon "NVGoggles";
	      _unit selectweapon primaryweapon _unit;
	};
      };
   };

// ====================================================================================

// LOADOUT: ASSISTANT AUTOMATIC RIFLEMAN
// The loadouts differ slightly for each faction.

   case "aar":
   {
      switch (_faction) do
      {
      	case "ru":
	{
	      removeallweapons _unit;
	      {_unit addmagazine _riflemag} foreach [1,2,3,4,5];
	      {_unit addmagazine _MGmag;} foreach [1,2];
	      {_unit addmagazine _Grenade} foreach [1,2];
	      _unit addweapon _rifle;
	      _unit addweapon "NVGoggles";
	      _unit selectweapon primaryweapon _unit;
      	};
      	case "usmc":
   	{
	      removeallweapons _unit;
	      {_unit addmagazine _riflemag} foreach [1,2,3,4,5];
     	      {_unit addmagazine _Grenade} foreach [1,2];
	      {_unit addmagazine _MGmag;} foreach [1,2];
	      _unit addweapon _rifle;
	      _unit addweapon "NVGoggles";
	      _unit selectweapon primaryweapon _unit;
      	};
      	case "gue":
	{
	      removeallweapons _unit;
	      {_unit addmagazine _riflemag} foreach [1,2,3,4,5];
	      {_unit addmagazine _MGmag;} foreach [1,2];
	      {_unit addmagazine _Grenade} foreach [1,2];
	      _unit addweapon _rifle;
	      _unit addweapon "NVGoggles";
	      _unit selectweapon primaryweapon _unit;
      	};
	case "ins":
	{
	      removeallweapons _unit;
	      {_unit addmagazine _riflemag} foreach [1,2,3,4,5];
	      {_unit addmagazine _MGmag;} foreach [1,2];
	      {_unit addmagazine _Grenade} foreach [1,2];
	      _unit addweapon _rifle;
	      _unit addweapon "NVGoggles";
	      _unit selectweapon primaryweapon _unit;
      	};
	case "cdf":
	{
	      removeallweapons _unit;
	      {_unit addmagazine _riflemag} foreach [1,2,3,4,5];
	      {_unit addmagazine _MGmag;} foreach [1,2];
	      {_unit addmagazine _Grenade} foreach [1,2];
	      _unit addweapon _rifle;
	      _unit addweapon "NVGoggles";
	      _unit selectweapon primaryweapon _unit;
      	};
      };
   };

// ====================================================================================

// LOADOUT: RIFLEMAN

   case "r":
   {
      removeallweapons _unit;
      {_unit addmagazine _riflemag} foreach [1,2,3,4,5,6,7];
      {_unit addmagazine _grenade} foreach [1,2];
      _unit addweapon _rifle;
      _unit addweapon "NVGoggles";
      _unit selectweapon primaryweapon _unit;
   };

// ====================================================================================

// LOADOUT: RIFLEMAN (AT)

   case "rat":
   {
      removeallweapons _unit;
      {_unit addmagazine _riflemag} foreach [1,2,3,4,5,6];
      {_unit addmagazine _atmag} foreach [1];
      {_unit addmagazine _grenade} foreach [1,2];
      _unit addweapon _at;
      _unit addweapon _rifle;
      _unit addweapon "NVGoggles";
      _unit selectweapon primaryweapon _unit;
   };

// ====================================================================================

// LOADOUT: MEDIUM MG GUNNER

   case "mmgg":
   {
      removeallweapons _unit;
      {_unit addmagazine _mediumMGmag} foreach [1,2,3,4];
      _unit addweapon _mediumMG;
      _unit addweapon "NVGoggles";
      _unit selectweapon primaryweapon _unit;
   };

// ====================================================================================

// LOADOUT: MEDIUM MG ASSISTANT GUNNER

   case "mmgag":
   {
      removeallweapons _unit;
      {_unit addmagazine _riflemag} foreach [1,2,3,4,5];
      {_unit addmagazine _mediumMGmag} foreach [1,2];
      _unit addweapon _rifle;
      _unit addmagazine "Laserbatteries";
      _unit addweapon "Laserdesignator";
      _unit addweapon "NVGoggles";
      _unit selectweapon primaryweapon _unit;
   };

// ====================================================================================

// LOADOUT: MEDIUM MG AMMO MAN

   case "mmgam":
   {
      removeallweapons _unit;
      {_unit addmagazine _riflemag} foreach [1,2,3,4,5];
      {_unit addmagazine _mediumMGmag} foreach [1,2];
      _unit addweapon _rifle;      
      _unit addweapon "NVGoggles";
      _unit selectweapon primaryweapon _unit;
   };

// ====================================================================================

// LOADOUT: MEDIUM AT GUNNER

   case "matg":
   {
      removeallweapons _unit;
      {_unit addmagazine _mediumATmag1;} foreach [1,2];
      _unit addweapon _mediumAT;
      {_unit addmagazine _medicmag} foreach [1,2,3];
      _unit addweapon _medicrifle;
      _unit addweapon "NVGoggles";
   };

// ====================================================================================

// LOADOUT: MEDIUM AT ASSISTANT GUNNER

   case "matag":
   {
      removeallweapons _unit;
      {_unit addmagazine _medicmag} foreach [1,2,3,4,5];
      _unit addweapon _medicrifle;
      _unit addmagazine "Laserbatteries";
      _unit addweapon "Laserdesignator";
      _unit addweapon "NVGoggles";
      _unit selectweapon primaryweapon _unit; 
   };

// ====================================================================================

// LOADOUT: MEDIUM AT AMMO MAN

   case "matam":
   {
      removeallweapons _unit;
      {_unit addmagazine _medicmag} foreach [1,2,3,4,5];
      {_unit addmagazine _mediumATmag1;} foreach [1,2];
      _unit addweapon _medicrifle;
      _unit addweapon "NVGoggles";
      _unit selectweapon primaryweapon _unit;
   };
   
// ====================================================================================

// LOADOUT: HEAVY AT GUNNER

   case "hatg":
   {
      removeallweapons _unit;
      {_unit addmagazine _heavyATmag1;} foreach [1];
      _unit addweapon _heavyAT;
      {_unit addmagazine _medicmag} foreach [1,2,3];
      _unit addweapon _medicrifle;
      _unit addweapon "NVGoggles";
   };

// ====================================================================================

// LOADOUT: HEAVY AT ASSISTANT GUNNER

   case "hatag":
   {
      removeallweapons _unit;
      {_unit addmagazine _medicmag} foreach [1,2,3,4,5];
      _unit addweapon _medicrifle;
      _unit addmagazine "Laserbatteries";
      _unit addweapon "Laserdesignator";
      _unit addweapon "NVGoggles";
      _unit selectweapon primaryweapon _unit; 
   };

// ====================================================================================

// LOADOUT: HEAVY AT AMMO MAN

   case "hatam":
   {
      removeallweapons _unit;
      {_unit addmagazine _medicmag} foreach [1,2,3,4,5];
      {_unit addmagazine _heavyATmag1;} foreach [1];
      _unit addweapon _medicrifle;
      _unit addweapon "NVGoggles";
      _unit selectweapon primaryweapon _unit;
   };

// ====================================================================================

// LOADOUT: SNIPER

   case "sn":
   {
      removeallweapons _unit;
      {_unit addmagazine _snmag} foreach [1,2,3,4,5];
      _unit addweapon _snrifle;
      _unit addweapon "Binocular";
      _unit addweapon "NVGoggles";
      _unit selectweapon primaryweapon _unit; 
   };

// ====================================================================================

// LOADOUT: SPOTTER

   case "sp":
   {
      removeallweapons _unit;
      {_unit addmagazine _spmag} foreach [1,2,3,4];
      {_unit addmagazine _snmag} foreach [1,2,3];
      _unit addweapon _sprifle;
      _unit addmagazine "Laserbatteries";
      _unit addweapon "Laserdesignator";
      _unit addweapon "NVGoggles";
      _unit selectweapon primaryweapon _unit; 
   };

// ====================================================================================

// ERROR CHECKING
// If the unit type could not be successfully detected the script exits with an error.

   default
   {
   if (true) exitwith {player globalchat format ["DEBUG (f\common\@ShackTac_assignGear.sqf): Unit = %1. Gear template %2 does not exist.",_unit,_typeofunit]};
   };
};