
#include "lib\common.h" ;

objectiveFriendlyFor={
     private ["_f"] ;
     _f=[VAR(ARG0,owner),ARG1] call sidesEqual ; 
     _f ;
} ;

objectiveHostileFor={
     private ["_f"] ;
     _f=[VAR(ARG0,owner),[[ARG1] call strToSide] call otherSide] call sidesEqual ; 
     _f ;
} ;


if (not isServer) exitwith {} ;



/*This only runs on the server*/


VAR_DEFAULT(CTF_objectiveCaptureTime,10);
VAR_DEFAULT(CTF_allowDominationWin,false);
VAR_DEFAULT(CTF_allowNeutralisationWin,false);
VAR_DEFAULT(CTF_objectiveDamageThreshold,0.5) ;
VAR_DEFAULT(CTF_objectiveCaptureScore,1) ;

CHObjectives =[];


createFlag = {
     private ["_flag","_marker" ];
     _marker = ARG0 ;
     _flag = "FlagCarrierRU" createVehicle markerPos _marker ;
     _flag setPos markerPos _marker ;
     _flag setFlagSide sidefriendly ; //stop anyone taking it 
     _flag;
} ;


objectiveActions=[
     ["score","setNum",1],
     ["captureTime","setNum",CTF_objectiveCaptureTime],
     ["damageThreshold","setNum",CTF_objectiveDamageThreshold],
     ["hold","setTrue",false],
     ["nobuildings","setTrue",false],
     ["destroy","setTrue",false],
     ["mobile","setTrue",false],
     ["hostage","setTrue",false],
     ["safezone","setTrue",false],
     ["track","setnum",10000],
     ["threshold","setnum",1],
     ["caches","setnum",0],
     ["west",{SETVARP(_r,owner,_modifier)}],
     ["east",{SETVARP(_r,owner,_modifier)}],
     ["hidden","setTrue",false],
     ["uncertainty","setNum",0],
     ["flagheight","setNum",0],
     ["height","setNum",0],
     ["sign","setString","none"],
     ["side","setString","neutral"],
     ["flag",{ 
	  _mrk = [_modifier,_s] call getModifierMarker ;
	       SETVARP(_r,flagObject,[_mrk] call createFlag) ;}
	  ]
     
     ] ;



applyObjectiveUncertainty={
     private ["_o","_m"] ;
     _o = ARG0; 
     _m = VAR(_o,marker);
     if (VAR(_o,uncertainty) !=0) then {
	  SETVARP(_o,originalMarkerSize,markerSize _m) ;
	  [_m,VAR(_o,uncertainty)] call initUncertainMarker ;
	  VAR(_o,label) setMarkerPos markerpos _m ;
     } ;
} ;


setObjectiveUncertainty={
     private["_o","_u","_m"] ;
     _o = ARG0;
     _u = ARG1 ;
     SETVARP(_o,uncertainty,_u) ;
     _m = VAR(_o,marker);
     [VAR(_o,center),_m,_u] call narrowUncertainMarker ;
     //make sure that we don't shrink objective markers to nothing when we 
     //have low uncertainty
     if (EL(markerSize _m,0) < EL(VAR(_o,originalMarkerSize),0)) then {
	  _m setMarkerSize VAR(_o,originalMarkerSize) ;
     } ;
     VAR(_o,label) setMarkerPos markerpos _m ;
} ;

createObjective={
     private ["_m","_o","_labelled","_s","_name","_modifiers","_p"] ;
     _m=ARG0 ;

     //special case for icons - they get a flag added automatically
     if (markerShape _m == "ICON") then {
	  _m setMarkerText ((markerText _m) + ",flag") ;
     } ;
     _s=[_m] call getRegionAndModifiers ;
     _o = EL(_s,0) ;
     _modifiers = EL(_s,1) ;
     _name = EL(_modifiers,0);
     _labelled = false ;

     [_m] call addJIPsafeMarker ;


     SETVARP(_o,flagObject,objnull); 
     SETVARP(_o,objName,_name) ;
     SETVARP(_o,eastPts,0); 
     SETVARP(_o,westPts,0);
     SETVARP(_o,east_precondition,objnull);
     SETVARP(_o,west_precondition,objnull);
     SETVARP(_o,owner,"neutral");

     [_s,objectiveActions] call handleActions ;
     if (_o getVariable "destroy") then {[_o] call makeDestroyObjective ;};
     if (not isNull (_o getVariable "flagObject")) then {
	  (_o getvariable "label") setMarkerType "Flag1";
	  (_o getvariable "label") setMarkerPos position ( _o getVariable "flagObject");
	  _p=position VAR(_o,flagObject) ;
	  _p set [2,VAR(_o,flagHeight)] ;
	  VAR(_o,flagObject) setPos _p ;
     }  else  {
	  (_o getvariable "label") setMarkerType "mil_objective";
     } ;
     if ((_o getVariable "owner") == "west") then {
	 SETVARP(_o,westPts,_o getVariable "captureTime");
     } ;
     if ((_o getVariable "owner") == "east") then {
	  SETVARP(_o,eastPts,_o getVariable "captureTime");
     } ;

     [_o] call applyObjectiveUncertainty ;

     if (VAR(_o,hidden)) then {
	  VAR(_o,marker) setmarkerPos [1,1,1] ;
	  VAR(_o,label) setmarkerPos [1,1,1] ;
     } ;

     //now mark up the objective on the map
     [_o,_o getVariable "owner"]  call markObjectiveHeldBy ;
     [_o,VAR(_o,sign)] call markRegion ;
     _o, ;
} ;

createObjectives = {
     private ["_f","_c","_o","_r"] ;
     _f = ["objective"] call findMarkers ;
     
     {
	  _r=[_x] call createObjective ;
	  CHObjectives = CHObjectives + [_r] ; 
     } foreach _f ;
     PUBLISH(ObjectiveList,CHObjectives);
     doneObjectives=true ;
     [] call initScore ;
     //for AAS mode, set up links to control capture conditions
     for "_c" from 0 to (count CHObjectives -1) do {
	  _o = CHObjectives select _c ;
	  if (_c >0) then {
	       SETVARP(_o,east_precondition, CHObjectives select (_c-1));
	  };  
	  if (_c < count CHObjectives-1) then {
	       SETVARP(_o,west_precondition, CHObjectives select (_c+1));
	  } ;
     } ;
};



objectivesMonitor = {
     private ["_tt","_t","_o","_e","_w","_status","_p","_epts","_wpts","_n"];
     waitUntil {gameStarted} ;
     //if there are no objectives, there is no point in running the monitor !
     while {count CHObjectives >0} do {
	  _epts = 0 ;   _wpts = 0 ;
	  _e =0 ;   _w= 0 ; _n=0;
	  _status = [] ;
	  {
	       if ([_x] call isDestroyObjective) then {
		    _t = [_x] call isObjectiveDestroyed ;
		    _p = _x getVariable "captureTime" ;
	       } else {
		    if (VAR(_x,safezone)) then {
			 _tt = [_x] call safezoneHeldBy ;
		    } else {
			 _tt = [_x] call objectiveHeldBy ;
		    } ;
		    _t = EL(_tt,0) ;
		    _p= EL(_tt,1) ;
	       } ;
	       switch (_t) do {
	       case "none" : {if ([_x] call isHoldObjective) then {[_x,1] call moveTowardsNeutral};} ;
	       case "contested" : {[_x,1] call moveTowardsNeutral; };
	       case "east" : {[_x,_p] call moveTowardsEast; };
	       case "west" : {[_x,_p] call moveTowardsWest; };
	       }; 
	       _o = _x getVariable "owner" ;
	       _status = _status+ [_o] ;

	       if (_o == "east") then {
		    _epts = _epts +(_x getVariable "score") ;
		    _e=_e+1;
	       } ;
	       if (_o == "west") then {
		    _wpts = _wpts +(_x getVariable "score") ;
		    _w = _w +1 ;
	       } ;
	       if (_o == "neutral") then {
		    _n = _n +1 ;
	       } ;

	       
	  } foreach CHObjectives ;
	  [_epts,_wpts,_status] call updateScoreStatus ;
	  if ((CTF_gameType == "AAS") or (CTF_allowDominationWin)) then {
	       if (_e == count CHObjectives) then {["East"] call allObjectivesTaken} ;
	       if (_w == count CHObjectives) then {["West"] call allObjectivesTaken} ;
	  };
	  if (CTF_allowNeutralisationWin) then {
	       if (_w+_n == count CHObjectives) then {["West"] call allObjectivesTaken} ;
	       if (_e+_n == count CHObjectives) then {["East"] call allObjectivesTaken} ;
	  } ;
	  sleep 1 ;
     } ;
} ;


objectiveLockedForEast = {
     private ["_o","_pre","_ret"] ;
     _o = ARG0 ;
     _pre = _o getVariable "east_precondition" ;
     if ((isNull _pre) or (_pre getVariable "owner" == "east")) then {
	  _ret = false ;
     } else {_ret = true;};
     _ret ;
} ;

objectiveLockedForWest = {
     private ["_o","_pre","_ret"] ;
     _o = ARG0 ;
     _pre = _o getVariable "west_precondition" ;
     if ((isNull _pre) or (_pre getVariable "owner" == "west")) then {
	  _ret = false ;
     } else {_ret = true;} ;
     _ret ;
} ;



isHoldObjective={
     (ARG0 getVariable "hold");
} ;
isDestroyObjective={
     (ARG0 getVariable "destroy");
} ;


safezoneHeldBy ={
     private ["_r","_m","_ret","_c"];
     _r = ARG0 ;
     _c = 0 ;
     _m = [_r,"Civilian"] call objectsInsideRegion ;
     {
	  if (alive _x) then {
	       _c = _c+1 ;
	  } ;
     } foreach _m ;
     _ret = "none";
     if (_c >= VAR(_r,threshold)) then {_ret = VAR(_r,side)} ;
     [_ret,_c] ;
} ;

objectiveHeldBy ={
     private ["_r","_m","_ret","_e","_w"];
     _r = ARG0 ;
     _e = 0 ;
     _w = 0 ;
     _m = [_r,"Man"] call objectsInsideRegion ;
     {
	  if (alive _x) then {
	       if ([_x] call plrSide  == east) then {_e=_e+1;} ;  
	       if ([_x] call plrSide  == west) then {_w=_w+1;} ;  
	       _x addScore CTF_objectiveCaptureScore; //reward players
	  } ;
     } foreach _m ;
     if (CTF_gameType =="AAS") then {
	  if ([_r] call objectiveLockedForEast) then {
	  _e = 0 ; 
	  } ;
	  if ([_r] call objectiveLockedForWest) then {
	       _w = 0 ; 
	  } ;
     };
     _ret = "none";
     if (_e ==0 and _w >=VAR(_r,threshold)) then {_ret = "west";} ;
     if (_w ==0 and _e >=VAR(_r,threshold)) then {_ret = "east";} ;
     if (_w >0 and _e>0) then {_ret="contested";} ;
     [_ret,abs(_e-_w)] ;
} ;

markObjectiveHeldBy ={
     private ["_o","_t","_c","_txt","_m","_flg"] ;
     _o = ARG0 ;
     _t = ARG1 ;
     _c = "ColorWhite" ;
     _txt ="ctf\flags\neutral.jpg";
     if ((_t == "neutral") and ([_o] call isDestroyObjective)) then {
	  if (VAR(_o,hidden)) then {
	       VAR(_o,marker) setMarkerPos VAR(_o,center) ;
	       VAR(_o,label) setMarkerPos VAR(_o,center) ;
	  } ;
     } ;
     if (_t == "east") then {_c = "ColorRed"; _txt = "ctf\flags\east.jpg";} ;
     if (_t == "west") then {_c = "ColorBlue"; _txt = "ctf\flags\west.jpg";} ;
     if (not isNull (_o getVariable "flagObject" )) then {
	  _flg = _o getVariable "flagObject" ;
	  _flg setFlagTexture _txt;
     } ;
     _m = _o getVariable "marker" ;
     _m setMarkerColor _c ;
} ;

moveTowardsNeutral = {
     private ["_o","_e","_w","_pts"];
     _o = ARG0 ;
     _pts = ARG1 ;
     _e = _o getVariable "eastpts" ;
     _w = _o getVariable "westpts" ;
     if (_e > _pts) then {SETVARP(_o,eastpts,_e-_pts) ;}
     else {SETVARP(_o,eastpts,0); _e=0 ;} ;
     if (_w > _pts) then {SETVARP(_o,westpts,_w-_pts) ;}
     else {SETVARP(_o,westpts,0) ; _w=0;} ;
     
     if (_e+_w == 0) then {
	  [_o,"neutral"] call objectiveGoneTo ;
     } ;
} ;

moveTowardsWest = {
     private ["_o","_e","_w","_pts","_h"];
     _o = ARG0 ;
     _pts = ARG1;
     _e = _o getVariable "eastpts" ;
     if (_e >0) then { 
	  [_o,_pts] call moveTowardsNeutral;
     } else {
	  _h = _o getVariable "captureTime" ;
	  _w = _o getVariable "westpts" ;
	  if (_w <_h-_pts) then {SETVARP(_o,westpts,_w+_pts) ;}
	  else {
	       //we've just been taken by west !
	       SETVARP(_o,westpts,_h) ;
	       [_o,"west"] call objectiveGoneTo ;
	  } ;
     } ;
} ;

moveTowardsEast = {
     private ["_o","_e","_w","_pts","_h"];
     _o = ARG0 ;
     _pts = ARG1;
     _w = _o getVariable "westpts" ;
     if (_w >0) then { 
	  [_o,_pts] call moveTowardsNeutral;
     } else {
	  _h = _o getVariable "captureTime" ;
	  _e = _o getVariable "eastpts" ;
	  if (_e <_h-_pts) then {SETVARP(_o,eastpts,_e+_pts) ;} 
	  else {
	       //we've just been taken by east !
	       SETVARP(_o,eastpts,_h) ;	     
	       [_o,"east"] call objectiveGoneTo ;
	  } ;
	  
     } ;
} ;

objectiveGoneTo ={
     private ["_o","_t"] ;
     _o = ARG0 ;
     _t = ARG1 ;
     if (_o getVariable "owner" != _t) then 
     {
	  [_o getVariable "objName",_t] call objectiveTaken ;
	  [_o,_t] call markObjectiveHeldBy ;
	  SETVARP(_o,owner,_t);
     } ;
} ;


//This broadcasts the OBjNames to clients
[] call createObjectives ;
[] spawn { [] call objectivesMonitor ;};



