#include "lib\common.h"

if (not isServer) exitwith {} ;


//Construct a list of vehicle parks...

arts =[] ;

artilleryActions=[
     ["salvo","setNum",6],
     ["bore","setString","81"],
     ["interval","setString","30"],
     ["grouping","setNum",3],
     ["wp","setTrue",false],
     ["flare","setTrue",false],
     ["airburst","setNum",0]
     ] ;


borelookup=[
     "81","ARTY_Sh_81_HE",
     "82","ARTY_Sh_82_HE",
     "105","ARTY_Sh_105_HE",
     "122","ARTY_Sh_122_HE",
     "120","ARTY_R_120mm_HE",
     "227","ARTY_R_227mm_HE"
     ] ;


createArtilleries = {
     private ["_r","_b","_s"];
     //Allow the user to specify different respawn delays for different carparks
     //Search the namespace for markers that look like carparks

     {
	  _s = [_x] call getRegionAndModifiers ;
	  _r = [_s,artilleryActions] call handleActions ;
	  _b = borelookup find (_r getVariable "bore");
	  if (_b >=0) then {
	       _r setVariable ["bore",borelookup select (_b+1)] ;
	  } ;
	  if (_r getVariable "wp") then { 
	       _r setVariable ["bore","ARTY_Sh_105_WP"] ;
	  } ;
	  if (_r getVariable "flare") then { 
	       _r setVariable ["bore","ARTY_Flare_medium"] ;
	  } ;

	  arts = arts + [_r] ;
     } foreach (["artillery"] call findMarkers) ; ; 
} ;

reapShells = [] ;
artilleryReaperTask={
     private ["_sh","_ttl","_lifetime"] ;
     _lifetime = 30 ;
     while {not gameOver} do {
	  if (count reapShells > 0) then {
	       _sh = reapShells select 0 ;
	       _ttl =  (_sh getVariable "createTime") + _lifetime - time ; 
	       if (_ttl < 0) then {
		    reapShells = reapShells - _sh ;
	       } else {
		    sleep _ttl ;
	       } 
	  } else {
	       sleep  _lifetime;
	  } ;
	  sleep 1 ;//  we should never need this - it's just in case something
	  //goes wrong witht the reapShells counting;
     } ;
} ;

artilleryTask ={
     private ["_r","_n","_i","_p","_sh","_avgDelay"] ;
     _r = ARG0;
     while {not gameOver} do {
	  sleep ([_r getVariable "interval"] call getInterval) ;
	  _n = _r getVariable "salvo" ;
	  _avgDelay = 2 * (_r getVariable "grouping" )/_n ;
	  for "_i" from 1 to _n do {
	       sleep (random _avgDelay) ;
	       _p = [_r] call randPosInsideRegion;
	       _p set [2,_r getVariable "airburst"] ;
	       _sh =  (_r getVariable "bore")  createVehicle (_p)  ;
	       //DO WE NEED TO DO THIS ????? CHECK ARTY code
	       _sh setVariable ["createTime",time] ;
	       reapShells = reapShells +[_sh ];

	  } ;
	  
     } ;
} ;

call createArtilleries ;



{
     [_x] spawn { _this call artilleryTask ;};
} foreach arts ;

//[] spawn {call artilleryReaperTask ;} ;
