#include "lib\common.h"

// task that checks whether each side still has players in play

eastInPlay=0 ;
westInPlay=0 ;
eastAcc=0;
westAcc=0;
VAR_DEFAULT(CTF_gameStartThreshold,1) ;

if (isServer) then {
     
     //There is a fundamental problem here which is that the playableUnits 
     //function doesn't return players which have just been killed but not yet
     //respawned. To work around this, we can hard-code the fact that we know
     //the respawn time is actually 1 second 
     //Therefore we put in some averaging and only allow the number of
     //players to be set to zero if we have seen 0 players for 5 consecutive
     //seconds
     
     inPlayMonitor={
	  private ["_side","_i","_e","_w"] ;
	  while {not gameOver} do {
	       _e = 0 ; _w = 0 ;
	       {
		    _side = [_x] call plrSide ; 
		    _i = ["INPLAY",_x,true] call serverGetVarDefault ;
		    if ((_side ==east) and _i) then {
			 _e = _e +1 ;
		    } ;
		    if ((_side ==west) and _i) then {
			 _w = _w +1 ;
		    } ;
	       } foreach call xPlayableUnits ; 
	       eastAcc = (eastAcc+_e)/2 ;
	       westAcc = (westAcc+_w)/2 ;
	       if (eastAcc < (1/32)) then { eastInPlay = 0 ; } 
	       else {eastInPlay = ceil eastAcc;} ;
	       if (westAcc < (1/32)) then { westInPlay = 0 ; } 
	       else {westInPlay = ceil westAcc;};
	       sleep 1 ;
	  };
     } ;

     gameThresholdReached={
	  private ["_ret"] ;
	  //For games where there is just a single team don't check both sides !
	  if (CTF_gameType in ["COOP","DM","KOH","FF"]) then {
	       _ret = (eastInPlay+westInPlay) >= CTF_gameStartThreshold ;
	  } else {
	       _ret = (eastInPlay >= CTF_gameStartThreshold) and 
	       (westInPlay >= CTF_gameStartThreshold) ;
	  } ;
          if (not isMultiPlayer) then {_ret = true ;} ;
	  _ret ;
     } ;

     gameOutOfPlay={
	  private ["_ret"] ;
	  //By default assume two sides and that we play on until everyone has run out of
	  //lives
	  _ret = (eastInPlay <=0) or   (westInPlay <= 0) ;

	  //For COOP there is only one side but we play on until the last man is down
	  if (CTF_gameType in ["COOP"]) then {
	       _ret = (eastInPlay+westInPlay)  <= 0;
	  } ;
	  //For single-sided adversarial games, play on until only one player is left
	  if (CTF_gameType in ["DM","FF","KOH"]) then {
	       _ret = (eastInPlay+westInPlay)  <= 1;
	  };
	  if (not isMultiPlayer) then {_ret = false;} ;
	  _ret ;
     } ;

     [] spawn {[] call inPlayMonitor} ;
};

if (not isNull player) then {
     
     outOfPlay={
	  ["INPLAY",false] call clientSendVar ;
     } ;
     inPlay={
	  ["INPLAY",true] call clientSendVar ;
     } ;
     
     //just used for testing since it's a pain to have to respawn to test this
     inPlayTest ={
	  while {not gameOver} do {
	       sleep 5 ;
	       if ((player distance markerPos "internment") < 10) then {
		    call outOfPlay ;
	       } else {
		    call inPlay ;
	       };
	  } ;
     } ;
     //[] spawn {[] call inPlayTest;} ;
} ; 
