
//Do nothing if we are on the server


#include "lib\common.h" ;


/* if we're not on the server, create a set of regions to represent borders 
   and spawn protection
*/


if (isServer) then {
     VAR_DEFAULT(CTF_noFlyZoneHalfLife,100) ;

     noflyzoneActions=[
	  ["halflife","setnum",CTF_noFlyZoneHalfLife],
	  ["allowEast","setTrue",false],
	  ["allowWest","setTrue",false],
	  ["nowarn","settrue",false]
	  ] ;
     

     createnoflyzones={
	  private ["_s","_r","_noflyzones"] ;
	  _noflyzones = [] ;
	  {
	       _s = [_x,false]  call getRegionAndModifiers ;
	       _r = [_s,noflyzoneActions,false] call handleActions ;
	       _noflyzones= _noflyzones + [_r] ;
	  } foreach (["noflyzone"] call findMarkers) ;
	  PUBLISH(noFlyZones,_noflyzones) ;
     } ;

     [] spawn  {call createnoflyzones ;};
} ;

if (not isNull player) then {
     
     
     noflyzoneTask ={
	  private ["_warnTime","_plr","_dowarn","_r","_lastplrpos","_h","_unlucky"];
	  _r = ARG0 ;
	  
	  _warnTime = -10 ;
	  _h = _r getVariable "halflife" ;
	  _dowarn = not (_r getVariable "nowarn") ;
	  _lastplrpos = position player ;
	  while {not gameOver} do {
	       waituntil {alive player} ;
	       _plr = position player ;
	       //borders only affect those off the ground
	       //we've spawned a separate task to handle the ground
	       //side of things
	       if (EL(_plr,2) > 5) then {
		    if  ([_r,_plr] call insideRegion) then {
			 
			 if (_dowarn and (time - _warnTime > 10)) then {
			      titletext ["DANGER - you are flying into danger!","Plain down"] ;
			      _warnTime= time ;
			 } ;
			 
			 _unlucky = [_h,_plr distance _lastplrpos] call halfLifeExpired ;
			 if ( _unlucky) then {  
			      player call blowUp ;
			      titletext ["You were shot down","Plain down"] ;} 
		    } ;
	       };
	       _lastplrpos = _plr ;
	       sleep 1 ;
	  };
     } ;
     
     
     [] spawn {
	  private ["_noflyzones"] ;
	  _noflyzones = RECEIVE(noflyzones) ;
	  {
	       if ( 
		    ((playerside == west) and not  VAR(_x,allowWest)) or  
		    ((playerside == east) and not  VAR(_x,allowEast))  
		    ) then {
		    [VAR(_x,marker),
		     "ColorYellow",
		     "DiagGrid",
		     "No overflights!", 
		     "mil_warning"
			 ] call colourAndAddLabel ;
		    [_x] spawn {_this call noflyzoneTask;} ; 
	       } else {
		    deleteMarker VAR(_x,marker)  ;
	       } ;
	  } foreach _noflyzones ; 
     } ;
};
