
#include "ctf\dlgs.h"

/*

   You MUST  choose the game type by defining the GAMEMODE_ below  to be one of the following values:-
   "GAMEMODE_CTF" : standard Capture the Flag
   "GAMEMODE_DM"  : standard Deathmatch
   "GAMEMODE_TDM" : team deathmatch - east vs west where total team kills count
   "GAMEMODE_FF"  : Flag fight - like deathmatch but players can gain extra points
           by taking and delivering a flag
   "GAMEMODE_KOH" : King Of The Hill
   "GAMEMODE_CH" : Capture and Hold
   "GAMEMODE_AAS" : Advance and Secure
*/

#define GAMEMODE_AAS
//Change this to be the name of your mission
#define CTF_MISSION_NAME "AAS test_mission"
CTF_AUTHOR="Put your name here";
CTF_WEBSITE="http://sbs-clan.co.uk" ;



/*
  Lobby dialog choices go below this line.
  See the manual for options - you can replace these
  or remove them entirely
*/


START_LOBBY_DIALOGS
//        DLG_RESPAWNLIMIT
//        DLG_MAXSCORE_DM
//        DLG_MAXSCORE_CTF
//        DLG_MAXSCORE_CH
//        DLG_STARTSCORE_CH
//        DLG_SMOKE
//        DLG_GRENADES
//     	  DLG_FRIENDLYFIRE
//        DLG_ANTIGIMP
//	      DLG_ANTISHAKE
//        DLG_ANTICAMP
//        DLG_GRENADELAUNCHERS
//        DLG_SILENCED
//        DLG_SNIPERS
//        DLG_MGS
//        DLG_GPS
//        DLG_DOMINATION
//        DLG_FLAGTRACKER
//        DLG_FLAGTRACKERINTERVAL
//        DLG_TIMELIMIT1
//        DLG_TIMELIMIT2
//        DLG_DEATHCAM
//        DLG_TERRAINDETAIL
//        DLG_VIEWDISTANCE
//        DLG_TIMEOFDAY
END_LOBBY_DIALOGS



/* Lobby dialogs MUST go ABOVE this line */


#ifdef CALLED_FROM_INIT
/*  IMPORTANT .... Configuration variables must only go below this comment !
    |    |    |    |    |    |    |    |    |    |    |    |    |    |
    |    |    |    |    |    |    |    |    |    |    |    |    |    |
    V    V    V    V    V    V    V    V    V    V    V    V    V    V     */


/* Change the CTF_Titles array to modify the introductory text. 
   You can add or remove  lines if you want*/

CTF_Titles = [
     CTF_MISSION_NAME,
     "An example Advance and Secure map by "+CTF_AUTHOR,
     "East must take the Warehouse then the Courtyard then the Church",
     "West  must work in the opposite direction",
     "Play fair",
     "Good luck, and have fun"
     ] ;

//You can add notes to the mission by modifying the text below. Each section consists of a section name and a lengthy description.
//If you want, you can add more sections
//You can use the '+' sign to break up long descriptions 

CTF_Notes= [
     ["Author info", 
      "Mission designer: " + CTF_AUTHOR + "<br/>" +
      "Visit "+ CTF_WEBSITE + "<br/>" +
      "Gameplay scripts by [SBS]mac"
	  ],

     ["Hints", 
      "Know the score at all times.  With a good lead you may want to focus on maintaining the lead by defending the objectives you hold.  Learn the map terrain, find good hiding spots to defend the flag.<br/>" +
      "Use smoke to cover your movements" 
	  ],

     ["Important gameplay notes", 
      "Objectives can only be captured if you have killed all enemy players within them. Points are gained for every second that an objective remains in your hands. Some objectives may be worth more than others.  Objectives must be captured in order." 
	  ],

     ["Spawn Protection and borders", 
      "Each team spawn is fully protected so stay out of the enemy spawn or you will be killed.<br/>"+
      "If you shoot out of or into a spawn area you will be killed.<br/><br/>"+
      "Minefields protect the borders of the map - don't wander into these or you will be killed." 
	  ],

     ["Team Objectives", 
      "Earn points by capturing the objectives. The team with the most points at the end of the round wins."
	  ],

     ["Gametype", 
      "ADVANCE AND SECURE<br/><br/>Capture the objectives for points.  Read the team objectives for more information. "
	  ],

     ["Spectators", 
      "Spectator slots can be used by admins to view any of the players during the game.<br/>"+ 
      "The viewpoint can be cycled between players or camera modes by using the dialog buttons at the top of the screen.<br/>"+ 
      "Note that neither the 'internal' nor 'gunner' camera modes give a true indication of the players viewpoint. 'Gunner' mode will show scoped view whenever the player is standing still regardless of whether they are actually using the scope.  The scope magnification shown in 'gunner' view also does not match that seen by the player.<br/><br/>" +
      "Finally, remember that network or delays or lag may mean that what you see may be different in some regards to what the player is experiencing. Please take this into account when spectating."
	  ]
];

/*  You can modifiy any of the following variables
    Remember to uncomment them if you do by removing the 
  "//" at the beginning of the line  */
//CTF_allowBINO=false;
//CTF_allowDominationWin=false;
//CTF_allowGPS=false;
//CTF_allowGrenadeLaunchers=false;
//CTF_allowMachineGuns=false;
//CTF_allowNVG=false;
//CTF_allowNeutralisationWin=false;
//CTF_allowSilencedWeapons=false;
//CTF_allowSniperRifles=false;
//CTF_antiCamp=false;
//CTF_antiGimp=false;
//CTF_antiShake=false;
//CTF_autoTest=false;
//CTF_bodyRemovalDelay=120;
//CTF_borderHalfLife=10;
//CTF_borderSign="Sign_1L_Border";
//CTF_deathCam="body";
//CTF_deathPenalty=0;
//CTF_defaultWeapon="AK_107_pso";
//CTF_defaultWeaponEast=CTF_defaultWeapon;
//CTF_defaultWeaponWest=CTF_defaultWeapon;
//CTF_disableCommandMode=true;
//CTF_disableFriendlyFire=false;
//CTF_endWarnings="10,5,1";
//CTF_fightToTheLastMan=false;
//CTF_flagRespawnDelay=0;
//CTF_flagTouchDelay=5;
//CTF_flagTrackDelay=300;
//CTF_flagTrackInterval=30;
//CTF_gameLength=30;
//CTF_gameStartThreshold=1;
//CTF_grenades=3;
//CTF_hudNoClock=false;
//CTF_hudNoObjectives=false;
//CTF_hudNoScore=false;
//CTF_iff=true;
//CTF_introLength=30;
//CTF_introMusic="Track02_insertion";
//CTF_introType="FlyRound";
//CTF_lostFlagTime=300;
//CTF_minefieldHalfLife=10;
//CTF_minefieldSign="Sign_1L_Noentry";
//CTF_noFlyZoneHalfLife=100;
//CTF_objectiveCaptureScore=1;
//CTF_objectiveCaptureTime=10;
//CTF_objectiveDamageThreshold=0.5;
//CTF_outroLength=30;
//CTF_outroMusic="Track19_Debriefing";
//CTF_paraDropHeight=200;
//CTF_paraDropVehicle="C130J";
//CTF_playerRespawnLimit=100000;
//CTF_preserveLoadout=true;
//CTF_preserveLoadoutOnDeath=false;
//CTF_preservePlayerSpawnPos=true;
//CTF_preventSuicide=false;
//CTF_respawnDelay=15;
//CTF_reverseScore=false;
//CTF_scoreToWin=100000;
//CTF_skipIntro=false;
//CTF_smoke=2;
//CTF_spawnSign="Sign_Checkpoint";
//CTF_spectateAll=false;
//CTF_squadSize=3;
//CTF_teamTag=false;
//CTF_terrainGrid=50;
//CTF_testing=true;
//CTF_ticketLimit=100000;
//CTF_ticketLimitEast=CTF_ticketLimit;
//CTF_ticketLimitWest=CTF_ticketLimit;
//CTF_timeOfDay=-1;
//CTF_useSquads=false;
//CTF_vehicleOnlyRespawnDamaged=false;
//CTF_vehicleRepairTime=10;
//CTF_vehicleRespawnDelay=30;
//CTF_viewDistance=600;
//CTF_waveTiming=10;

/*  A    A    A    A    A    A    A    A    A    A    A    A    A    A
    |    |    |    |    |    |    |    |    |    |    |    |    |    |
    |    |    |    |    |    |    |    |    |    |    |    |    |    |
IMPORTANT .... Configuration variables must only go above this comment ! */
 
#endif



/* Don't put anything below this line... */

#ifdef GAMEMODE_COOP
	CTF_gameType="COOP" ;
#define ARMAGAME COOP 
#endif 
#ifdef GAMEMODE_CTF
	CTF_gameType="CTF" ;
#define ARMAGAME CTF 
#endif 
#ifdef GAMEMODE_RUGBY
	CTF_gameType="RUGBY" ;
#define ARMAGAME CTF 
#endif 
#ifdef GAMEMODE_ECL
	CTF_gameType="ECL" ;
#define ARMAGAME CTF 
#endif 
#ifdef GAMEMODE_DM
	CTF_gameType="DM" ;
#define ARMAGAME DM 
#endif
#ifdef GAMEMODE_FF
	CTF_gameType="FF" ;
#define ARMAGAME FF
#endif
#ifdef GAMEMODE_TDM
	CTF_gameType="TDM" ;
#define ARMAGAME TEAM 
#endif
#ifdef GAMEMODE_KOH
	CTF_gameType="KOH" ;
#define ARMAGAME FF 
#endif
#ifdef GAMEMODE_INSURGENCY
	CTF_gameType="INSURGENCY" ;
#define ARMAGAME HOLD 
#endif
#ifdef GAMEMODE_CH
	CTF_gameType="C&H" ;
#define ARMAGAME HOLD 
#endif
#ifdef GAMEMODE_AAS
	CTF_gameType="AAS" ;
#define ARMAGAME HOLD 
#endif
