
#define PP preprocessfilelinenumbers

diag_log "===============PVP SCRIPT PACK=====================================";

#include "ctf\lib\common.h"

//Ensure we wait for JIP to complete
waituntil {isServer or not isNull player} ;
//this needs to be here now since so much depends on it
gameOver=false ;

if (ISserver) then {
     JIPOBJECT = "RoadCone" createVehicle [1,1,1] ; 
     publicVariable "JIPOBJECT" ;
} ;

[] call compile PP "ctfConfigWrapper.sqf";
VAR_DEFAULT(CTF_autoTest,false) ;
if (CTF_autoTest) then {
     call compile PP "test\test.sqf" ;
} ;


VAR_DEFAULT(playerInterned,false) ;
VAR_DEFAULT(CTF_terrainGrid,50) ;
VAR_DEFAULT(CTF_viewDistance,600) ;
VAR_DEFAULT(playerInterned,false) ;
VAR_DEFAULT(CTF_timeOfDay,-1) ;
VAR_DEFAULT(CTF_testing,isServer and (not isnull player) ); 

if (CTF_timeOfDay >=0) then {
     _d = date ;
     _d set [3,CTF_timeofDay] ;
     setdate _d ;
} ;


if (not isNull player) then { 

     logocam = "camera" camCreate [0,0,100] ; ;
     logocam cameraEffect ["Internal","Back"] ;
     logocam camSetTarget [0,0,0] ;
     logocam camCommit 0 ;     TitleRsc ["logo","BLACK FADED",2];
     titleFadeout 100 ;
     VAR_DEFAULT(CTF_Notes,[]) ;
     for "_i" from 1 to (count CTF_Notes) do  
     {
	  _x = EL(CTF_Notes,count CTF_notes-_i) ;
	  _diary =player createDiaryRecord ["diary",_x] ;
     };
} ;


setViewDistance  CTF_viewDistance;
//disable grass
setTerrainGrid CTF_terrainGrid ;

//It seems that arma needs some time to issue variables to clients, even in editor mode.
//Therefore we allow init to complete before spawning off all the stuff we want to do 

[] spawn {
//give the logo time to appear
if (not CTF_testing) then {sleep 5 ;} ;
//This variable is used to indicate that the intro sequence has finished and
//the game really has started
initFinished = false ; 
gameStarted = false ;

//Adding -10K to the player rating puts the 'side' to ENEMY
//which messes up the detection of ours and theirs spawns in
//borderControl. Therefore store the original player side in
//a global variable


//Start by compiling code and adding functions

[] call compile PP "ctf\lib\sides.sqf";
[] call compile PP "ctf\lib\pos.sqf";
[] call compile PP "ctf\lib\weapons.sqf";
[] call compile PP "ctf\lib\region.sqf";
[] call compile PP "ctf\lib\markers.sqf";
[] call compile PP "ctf\lib\strings.sqf";
[] call compile PP "ctf\lib\arrays.sqf";
[] call compile PP "ctf\lib\halflife.sqf";
[] call compile PP "ctf\lib\errorlog.sqf";
[] call compile PP "ctf\lib\ipc.sqf";
[] call compile PP "ctf\playerInfo.sqf" ;
[] call compile PP "ctf\jipEnable.sqf" ;
[] call compile PP "ctf\squad.sqf" ;
[] call compile PP "ctf\modifiers.sqf" ;
[] call compile PP "ctf\artillery.sqf" ;
[] call compile PP "ctf\special.sqf" ;
[] call compile PP "ctf\uncertainty.sqf" ;
[] call compile PP "ctf\uids.sqf" ;

//Make sure we have a centermap marker
if (getMarkerType "centermap" == "") then {
     if ((getMarkerType "respawn_east" == "") and (getmarkerType "respawn_west" == "")) then {
	  centerMap = createMarkerLocal["centerMap",position (playableUnits select 0)];
     } else {
	  if (getmarkerType "respawn_east" == "") then  {
	       centerMap = createMarkerLocal["centerMap",markerPos "respawn_west"];
	  };
	  if (getmarkerType "respawn_west" == "") then  {
	       centerMap = createMarkerLocal["centerMap",markerPos "respawn_east"];
	  };
	  if (getMarkerType "centermap" == "") then {
	       centerMap = createMarkerLocal["centerMap",[markerPos "respawn_east",markerPos "respawn_west"] call midpoint];
	  } ;
     } ;

} ;

//Add event handler to remove dead bodies - no side-effects
[] call compile PP "ctf\bodyremoval.sqf" ;

//add vehicle respawn - shouldn't have any visible effects
//but there is a nasty effect where bodies have to be deleted after a delay

[] call compile PP "ctf\vehicles.sqf";
[] call compile PP "ctf\guard.sqf";

//All of these alter the state of the world and objects in some way
[] call compile PP "ctf\ammo.sqf" ;
[] call compile PP "ctf\preventDamage.sqf";
[] call compile PP "ctf\levelBuildings.sqf";
//creates borders then spawns off task to check incursion
[] call compile PP "ctf\minefield.sqf";
[] call compile PP "ctf\border.sqf";
[] call compile PP "ctf\borderControl.sqf";
//spawns off a client-side task to monitor paradrops
//this entails checking borders which is why it is after bordercontrol
[] call compile PP "ctf\paraDrop.sqf";

//This spawns off a client-side task to repeat announcements from the server
[] call compile PP "ctf\announce.sqf";

//Spawns off client and server tasks to synchronise weather state
[] spawn compile PP "ctf\weatherSync.sqf";

[] call compile PP "ctf\rearm.sqf" ;
[] call compile PP "ctf\noflyzone.sqf" ;

[] call compile PP "ctf\noflag.sqf" ;


//Only certain kinds of maps need flag-control
if (CTF_gameType in ["CTF","RUGBY","ECL","FF","KOH"]) then {
      [] call compile PP "ctf\flagcontrol.sqf" ;
} ;
//create scoring system
[] call compile PP "ctf\game.sqf";
[] call compile PP "ctf\hud.sqf" ;
[] call compile PP "ctf\tags.sqf" ;
[] call compile PP "ctf\scores.sqf";

[] call compile PP "ctf\objectiveDestroy.sqf" ;
[] call compile PP "ctf\chobjectives.sqf" ;
[] call compile PP "ctf\tickets.sqf" ;
[] call compile PP "ctf\inPlay.sqf" ;

//For DM type maps, players must be made enemies of one another
if (CTF_gameType in ["FF","DM","KOH"]) then {
     if (not isNull player) then {player addRating (-(rating player) -100000) ;}; 
} ;

//display any errors found during the mission build...
call removeModifiers ;
call haltOnError ;

//Spawns task to blank screen if space bar is pressed - do this after intro sequence
[] spawn compile PP "ctf\disableCommandMode.sqf";
[] call  compile PP "ctf\antiGimp.sqf";
[] call  compile PP "ctf\spectator.sqf";

//Show the intro sequence (on client) 
[] call compile PP "ctf\camControl.sqf";
if (isNull player) then {
     //if we are a dedicated server, wait for the same time as the intro before
     //starting the game...
     [] spawn { sleep ([] call getIntroLength) ; gameStarted = true ; } ;
} else {
     gameStarted=true ;
} ;


initFinished = true ;

 [] call compile PP "ctf\anticamp.sqf" ;
 [] call compile PP "ctf\iff.sqf" ;
if (CTF_autoTest) then {
     call testRun ;
} ;

} ;
