#include "lib\common.h";


/* shared variable to indicate whether game is playing, ending (outro being played),
   or finished
*/

VAR_DEFAULT(CTF_gameLength,30);
VAR_DEFAULT(CTF_fightToTheLastMan,false);
VAR_DEFAULT(CTF_endWarnings,"10,5,1");

gameState="playing" ;
forceGameOver=false ;
GameTimeLeft=0;
gameOver=false ;
_trg1 = createTrigger ["EmptyDetector",[0,0,0]];
_trg1 setTriggerType "END1" ;
_trg1 setTriggerStatements["gameOver", "", ""]; 

TimeLeftString = {
     private ["_s"];
     switch (true) do {
	  case (GameTimeLeft == 0): {
	       _s="Waiting for players" ;
	  } ;
	  case ( GameTimeLeft < 3600) : {
	       _s = format ["%1m %2s left",floor(GameTimeLeft/60),floor(GameTimeLeft mod 60)]  ;
	  } ;
	  case (GameTimeLeft  > 50000): {
	       _s = "Unlimited Time" ;
	  };
	  default {
	       _s = format ["%1h %2m %3s left",
			    floor(GameTimeLeft/3600),
			    floor((GameTimeLeft/60) mod 60),
			    floor(GameTimeLeft mod 60)]  ;
	  } ;
     } ;
     _s ;
} ;


gameTimeFromNow={
     (GameTimeLeft - ARG0) ;
} ;

pastGameTime={
     (GameTimeLeft <= ARG0) ; 
} ;

timeToGameTime={
     (GameTimeLeft - ARG0) ;
} ;

cfTimeToGameTime={
     private "_n" ;
     _n = (GameTimeLeft - ARG0) ;
     if (_n < 0) then {_n =0;} ;
     floor (_n) ;
} ;

if (isServer) then {
     gameTicker ={
	  private ["_gameStartTime"];
	  waitUntil {gameStarted} ;
	  waitUntil {call gameThresholdReached;} ;
	  _gameStartTime = time ;
	  while { not forceGameOver} do {
	       sleep 1 ;
	       GameTimeLeft = _gameStartTime +(CTF_gameLength*60)-time ; 
	       publicVariable "GameTimeLeft" ;
	       if (GameTimeLeft <=0) then { forceGameOver = true;} ;
	       //if we are in test mode, there is no point in ending the
	       //game through lack of players !
	       if ((totalTickets_east<=0) and (not CTF_fightToTheLastMan)) then {
		    forceGameOver = true;
	       } ;
	       if ((totalTickets_west<=0) and (not CTF_fightToTheLastMan)) then {
		    forceGameOver = true;
	       } ;
	       if (call gameOutOfPlay) then {
		    forceGameOver = true;
	       };
	  } ;
	  call gameOverScore ;
	  gameState="ending" ; publicVariable "gameState" ;
	  //wait for the outro sequence time
	  sleep 30 ;
	  gameOver=true; 
     } ;
     [] spawn {[] call gameTicker;}
} ;

if (not isNull player) then {
     
     waitForGameOver = {
	  waituntil {gameState != "playing"} ;
	  call cancelPendingRespawn ;
	  call outroSequence ;
	  //trigger the end of the game
	  gameOver=true;
     } ;
     
     warnEndGame =
	  {
	       private ["_w"] ;
	       _w =[];
	       { _w = _w +[parseNumber _x ] ;} foreach ([CTF_endWarnings,","] call strSplit) ;
	       waituntil {gameState == "playing"} ;
	       while {not gameOver} do {
		    {
			 if ( abs(GameTimeLeft - _x*60) < 5) then {
			      hint format ["%1 minute%2 left",_x, if (_x==1) then {""} else {"s"} ];
			      _w = _w - [_x] ;
			 } ;
		    } foreach _w ;
		    sleep 5 ;
	       } ;
	       
	  } ;

     [] spawn {[] call waitForGameOver ;} ;
     [] spawn {[] call warnEndGame ;} ;
} ;


