#include "lib\common.h"

if (not isServer) exitwith {} ;

dcrew =[] ;


hostageMonitor={
     private ["_h","_p","_ldr"] ;
     _h = ARG0 ;
     while {alive _h} do {
	  _p = call xPlayableUnits ;
	  _ldr = leader _h ;
	  if (not ( _ldr in _p)) then {
	       //if we don't have a leader then look for one
	       {
		    if ((_x distance _h) < 2) then {
			 [ _h] joinsilent _x ; 
		    } ;
	       } foreach _p ;
	  } else {
	       //if we do have a leader, make sure we haven't lost them
	       if (_h distance leader _h > 20) then {
		    [_h] joinsilent grpNull ; };
	  } ;
	  sleep 5 ;
     } ; 
} ;

makeDestroyObjective={
     private ["_r","_veh","_bld","_v","_n","_c"] ;
     _r = ARG0 ;
     //Look for vehicles inside the objective
     _veh = ([_r,"LandVehicle"] call objectsInsideRegion) + ([_r,"Air"] call objectsInsideRegion) ;
     {
	  _v = _x ;
	  {
	       // start by turfing out any crew members that are in the vehicles
	       unassignVehicle _x ;
	       _x setPos [1,1,1] ;
	       //NASTY HACK !!!!!!
	       //Place the units in an array to be deleted layer - I think 
	       //this gives the server time to flush the position to the client
	       //before deleting the unit ??
	       dcrew = dcrew + [_x ];
	  } foreach crew _v ;
	  if (not (_r getVariable "mobile")) then { 
	       _v lock true ;
	       _v setfuel 0 ;
	  } else {
	       _v setVariable ["lastTrackTime",time] ;
	       _v setVariable ["tracker",["x",position _v,"mil_objective"] call addLabel] ;

	  } ;
     } foreach _veh;

     //Add ammo crates
     _bld = [_r,"ReammoBox"] call objectsInsideRegion ;
     
     _n = (count _bld)  - VAR(_r,caches) ;
     if (_n < (count _bld)) then {
	  for "_c" from 1 to _n do {
	       _v = EL(_bld,random ( -0.6 + count _bld)) ;
	       deleteVehicle _v ;
	       _bld = _bld - [_v] ;
	  } ;   
     } ; 
     
     {
	  _x allowDamage true ;
     } foreach _bld ;
     
     _veh = _veh + _bld ;

     
     if (not (_r getVariable "nobuildings")) then {
	  //Add buildings inside the objective
	  _bld = [_r,"building"] call objectsInsideRegion ;

	  {
	       _x allowDamage true ;
	  } foreach _bld ;
	  
	  _veh = _veh + _bld ;
     } ;

     if (VAR(_r,hostage)) then {
	  //Add civilian hostages inside the objective
	  _bld = [_r,"Civilian"] call objectsInsideRegion ;
	  
	  {
	       _x allowDamage true ;
	       if (VAR(_r,mobile)) then {
		    [_x] spawn {_this call hostageMonitor;} ; 
	       } ;
	  } foreach _bld ;
	  
	  _veh = _veh + _bld ;
     } ;

     _r setVariable ["objectArray",_veh] ;
};


objReapCrew ={
     sleep 5 ;
     while {count dCrew >0} do {
	  {
	       deleteVehicle _x;
	       dCrew = deadCrew -[_x] ;
	  } foreach dCrew ;
	  sleep 5 ;
     };
} ;




//Checks whether every object inside the objective has been damaged above the threshold
isObjectiveDestroyed = {
     private ["_obj","_v","_allDestroyed","_ret","_threshold","_thisDestroyed"];
     _obj = ARG0 ;
     
     
     _ret = "neutral" ;
     if (_obj getVariable "owner" != "neutral") then {
	  _v = _obj getVariable "objectArray" ;
	  _allDestroyed = true ;
	  _threshold=_obj getVariable "damageThreshold" ;
	  {
	       _thisDestroyed = true ;
	       if ((damage _x) < _threshold) then {
		    _thisDestroyed=false;
	       } ;
	       if (_obj getVariable "mobile") then {
		    if (time-(_x getVariable "lastTrackTime")> (_obj getVariable "track")) then {
			 (_x getVariable "tracker") setmarkerPos (position _x) ;
			 _x setVariable ["lastTrackTime",time] ;
			 if (_thisDestroyed) then {
			      (_x getVariable "tracker") setmarkerColor "ColorWhite" ;
			 } ;
		    } ;
	       } ;
	       _allDestroyed = _allDestroyed and _thisDestroyed ;
	  } foreach _v ;
	  
	  if (_allDestroyed) then {
	       _ret = "contested";
	       [_obj,0] call setObjectiveUncertainty ;
	  } else {
	       _ret = _obj getVariable "owner" ;
	  } ;
     } ;
     _ret ;
} ;

[] spawn { [] call objReapCrew;} ;
