#define FontM "Zeppelin32"
#define FontHTML "Zeppelin32"

#define ST_LEFT       0
#define ST_RIGHT      1
#define ST_CENTER     2
#define ST_FRAME      64

#define CT_STATIC     0
#define CT_BUTTON	  1
#define CT_EDIT       2
#define CT_ACTIVETEXT 11

class RscText
{
        type = CT_STATIC;
        idc = -1;
        style = ST_LEFT;
        colorBackground[] = {0, 0, 0, 0};
        colorText[] = {1, 1, 1, 1};
        font = FontM;
        sizeEx = 0.04;
};

class RscActiveText
{
  type = CT_ACTIVETEXT;
  idc = -1;
  style = ST_LEFT;
  color[] = {0, 0, 1, 1};
  colorActive[] = {1, 0, 0, 1};
  font = FontM;
  sizeEx = 0.04;
  soundEnter[] = {"ui\ui_over", 0.2, 1};
  soundPush[] = {, 0.2, 1};
  soundClick[] = {"ui\ui_ok", 0.2, 1};
  soundEscape[] = {"ui\ui_cc", 0.2, 1};
  default = false;
};

#define YPOS 0.01

class SpectatorDialog
{
  idd = 900;
  movingEnable = true;
  objects[] = { };
  controls[] = { PLAYERNAME, PREV,NEXT,CAMTYPE,PREVCAM,NEXTCAM};
  controlsBackground[]={SPECBACKGROUND} ;
  class SPECBACKGROUND : RscText
  {
     colorBackground[] = {0, 0, 0, 1};
     text = ;
     x = safeZoneX;
     y = saveZoneY;
     w = safeZoneW;
     h = 0.12;
  };

  class PLAYERNAME : RscText
  {
    idc = 100;
    style = ST_CENTER;
    x = 0.3;
    y = YPOS;
    w = 0.4;
    h = 0.05;
    text = "Spectating";
  };
  class PREV : RscActiveText
  {
    idc = 101;
    style = ST_CENTER;
    x = 0.2;
    y = YPOS;
    w = 0.1;
    h = 0.05;
    text = "<<";
    action = "call prevPlayer";
    default = true;
  };
  class NEXT : RscActiveText
  {
    idc = 102;
    style = ST_CENTER;
    x = 0.7;
    y = YPOS;
    w = 0.1;
    h = 0.05;
    text = ">>";
    action = "call nextPlayer";
    default = true;
  };
  class CAMTYPE : RscText
  {
    idc = 110;
    style = ST_CENTER;
    x = 0.3;
    y = YPOS+0.06;
    w = 0.4;
    h = 0.05;
    text = "Chase-cam";
  };
  class PREVCAM : RscActiveText
  {
    idc = 111;
    style = ST_CENTER;
    x = 0.2;
    y = YPOS+0.06;
    w = 0.1;
    h = 0.05;
    text = "<<";
    action = "call prevCam";
    default = true;
  };
  class NEXTCAM : RscActiveText
  {
    idc = 112;
    style = ST_CENTER;
    x = 0.7;
    y = YPOS+0.06;
    w = 0.1;
    h = 0.05;
    text = ">>";
    action = "call nextCam";
    default = true;
  };
};
