//creates a HUD to display relevant information for the game
#include "lib\common.h" ;

if (isNull player) exitwith {} ;


#define START_TAG 65100
#define NUMTAGS 10


availTags=[] ;
tagInit={
     private ["_c","_hud"] ;
     disableSerialization ;
     waitUntil {not hudIsHidden} ;
     _hud = uiNamespace getVariable "HUD";
     for "_c" from 0 to (NUMTAGS-1) do {
	  availTags set [_c,_hud displayCtrl (START_TAG+_c)] ;
     } ;
} ;

claimTag={
     private ["_t"] ; 
     _t = objNull ;
     if (count availTags >0) then {
	  _t = EL(availTags,0) ;
	  availTags = availTags -[_t] ;
     } ;
     _t ;
} ;

releaseTag={
     ARG0 ctrlSetTextColor[0,0,0,0] ;
     ARG0 ctrlsetPosition [-0.1,-0.1] ;
     ARG0 ctrlCommit 0 ;
     availTags=availTags+[ARG0] ;
} ;



playerTracker ={
     private ["_t","_u","_p" ];
     disableSerialization ;
     _u = ARG0 ;
     _t = [] call claimTag ;
     if (not isNull _t) then {
	  _t ctrlSetTextColor ARG1 ;
	  _t ctrlSetFade 0 ;
	  while {alive _u and (VAR(_u,tracking))} do {
	       _t ctrlSetText format ["%1 - %2m",name _u,ceil (_u distance player)] ;
	       _p = position _u;
	       if (count _p < 3) then {_p set [2,0];} ;
	       if (EL(_p,2) < 2) then {_p set [2,2];} ;
	       _p = worldtoscreen _p;
	       if (count _p != 2) then {
		    _p = [2,2] ;
	       } ;
	       _p set [2,0.2];
	       _p set [3,0.02];
	       _t ctrlSetposition _p ;
	       _t ctrlCommit 0.01 ;
	       sleep 0.01 ;
	  } ;
	  _t ctrlSetFade 1 ;
	  _t ctrlCommit 0.5 ;
	  sleep 1 ;
	  [_t] call releaseTag ;
     };
} ;


[] spawn {call tagInit;} ;
