#include "common.h"

basicRifles = ["ak_107_kobra","ak_107_pso","ak_74","ak_47_m","ak_47_s","aks_74_kobra","aks_74_pso","aks_74_u","aks_74_un_kobra","bizon","g36a","g36c","g36_c_sd_eotech","g36k","m1014","m16a2","m16a4","m16a4_acg","m4a1","m4a1_aim","m4a1_aim_camo","mp5a5","saiga12k","m8_carbine","m8_compact"] ;

rifles = ["ak_107_kobra","ak_107_gl_kobra","ak_107_gl_pso","ak_107_pso","ak_74","ak_74_gl","ak_47_m","ak_47_s","aks_74_kobra","aks_74_pso","aks_74_u","aks_74_un_kobra","bizon","bizon_silenced","g36a","g36c","g36_c_sd_eotech","g36k","m1014","m16a2","m16a2gl","m16a4","m16a4_gl","m16a4_acg_gl","m16a4_acg","m4a1","m4a1_hws_gl","m4a1_hws_gl_camo","m4a1_hws_gl_sd_camo","m4a1_rco_gl","m4a1_aim","m4a1_aim_camo","m4a1_aim_sd_camo","mp5a5","mp5sd","saiga12k","vss_vintorez","m8_carbine","m8_carbinegl","m8_compact"] ;

machineGuns = ["mg36","mk_48","m240","m249","pecheneg","pk","rpk_74","m8_saw"] ;

sniperRifles= ["huntingrifle","dmr","ksvk","m107","m24","m40a3","m4spr","svd","svd_camo","m8_sharpshooter"] ;


allRifles = rifles + machineGuns + sniperRifles ;

pistols=["colt1911","m9","m9sd","makarov","makarovsd"] ;

rockets=["igla","javelin","m136","metislauncher","rpg18","rpg7v","smaw","stinger","strela"] ;
rocketCapacity=["igla",2,"javelin",2,"m136",2,"metislauncher",2,"rpg18",2,"rpg7v",6,"smaw",6,"stinger",2,"strela",2] ;


explosives=["handgrenade","handgrenade_west","handgrenade_east","smokeshell","smokeshellred","smokeshellgreen","smokeshellyellow","smokeshellorange","smokeshellpurple","timebomb","pipebomb","mine","minee","handgrenade_stone"];

silenced = ["aks_74_un_kobra","bizon_silenced","g36_c_sd_eotech","m4a1_hws_gl_sd_camo","m4a1_aim_sd_camo","mp5sd","m9sd","makarovsd","vss_vintorez","mp5a5"];

grenadelaunchers = ["ak_107_gl_kobra","ak_107_gl_pso","ak_74_gl","m16a2gl","m16a4_gl","m16a4_acg_gl","m4a1_hws_gl","m4a1_hws_gl_camo","m4a1_hws_gl_sd_camo","m4a1_rco_gl"];


allWeapons = allRifles + pistols + rockets +explosives;

ammo = ["ak_107_kobra","30rnd_545x39_ak","ak_107_gl_kobra","30rnd_545x39_ak","ak_107_gl_pso","30rnd_545x39_ak","ak_107_pso","30rnd_545x39_ak","ak_74","30rnd_545x39_ak","ak_74_gl","30rnd_545x39_ak","ak_47_m","30rnd_762x39_ak47","ak_47_s","30rnd_762x39_ak47","aks_74_kobra","30rnd_545x39_ak","aks_74_pso","30rnd_545x39_ak","aks_74_u","30rnd_545x39_ak","aks_74_un_kobra","30rnd_545x39_aksd","bizon","64rnd_9x19_bizon","bizon_silenced","64rnd_9x19_sd_bizon","g36a","30rnd_556x45_g36","g36c","30rnd_556x45_g36","g36_c_sd_eotech","30rnd_556x45_g36sd","g36k","30rnd_556x45_g36","m1014","8rnd_b_beneli_74slug","m16a2","30rnd_556x45_stanag","m16a2gl","30rnd_556x45_stanag","m16a4","30rnd_556x45_stanag","m16a4_gl","30rnd_556x45_stanag","m16a4_acg_gl","30rnd_556x45_stanag","m16a4_acg","30rnd_556x45_stanag","m4a1","30rnd_556x45_stanag","m4a1_hws_gl","30rnd_556x45_stanag","m4a1_hws_gl_camo","30rnd_556x45_stanag","m4a1_hws_gl_sd_camo","30rnd_556x45_stanagsd","m4a1_rco_gl","30rnd_556x45_stanag","m4a1_aim","30rnd_556x45_stanag","m4a1_aim_camo","30rnd_556x45_stanag","m4a1_aim_sd_camo","30rnd_556x45_stanagsd","mp5a5","30rnd_9x19_mp5","mp5sd","30rnd_9x19_mp5sd","saiga12k","8rnd_b_saiga12_74slug","vss_vintorez","10rnd_9x39_sp5_vss","m8_carbine","30rnd_556x45_g36","m8_carbinegl","30rnd_556x45_g36","m8_compact","30rnd_556x45_g36","mg36","100rnd_556x45_betacmag","mk_48","100rnd_762x51_m240","m240","100rnd_762x51_m240","m249","200rnd_556x45_m249","pecheneg","100rnd_762x54_pk","pk","100rnd_762x54_pk","rpk_74","75rnd_545x39_rpk","m8_saw","30rnd_556x45_g36","huntingrifle","5x_22_lr_17_hmr","dmr","20rnd_762x51_dmr","ksvk","5rnd_127x108_ksvk","m107","10rnd_127x99_m107","m24","5rnd_762x51_m24","m40a3","5rnd_762x51_m24","m4spr","20rnd_556x45_stanag","svd","10rnd_762x54_svd","svd_camo","10rnd_762x54_svd","m8_sharpshooter","30rnd_556x45_g36","colt1911","7rnd_45acp_1911","m9","15rnd_9x19_m9","m9sd","15rnd_9x19_m9sd","makarov","8rnd_9x18_makarov","makarovsd","8rnd_9x18_makarovsd","igla","igla","javelin","javelin","m136","m136","metislauncher","at13","rpg18","rpg18","rpg7v","pg7v","smaw","smaw_heaa","stinger","stinger","strela","strela","ksvk","5rnd_127x108_ksvk"];

glammo = ["ak_107_gl_kobra","1rnd_he_gp25","ak_107_gl_pso","1rnd_he_gp25","ak_74_gl","1rnd_he_gp25","m16a2gl","1rnd_he_m203","m16a4_gl","1rnd_he_m203","m16a4_acg_gl","1rnd_he_m203","m4a1_hws_gl","1rnd_he_m203","m4a1_hws_gl_camo","1rnd_he_m203","m4a1_hws_gl_sd_camo","1rnd_he_m203","m4a1_rco_gl","1rnd_he_m203"];

textnames = ["AK-107","AK_107_kobra","AK-107 / GP25","AK_107_GL_kobra","AK107 / GP25 PSO","AK_107_GL_pso","AK-107 PSO","AK_107_pso","AK-74","AK_74","AK-74 / GP25","AK_74_GL","AKM","AK_47_M","AKS","AK_47_S","AKS-74 Kobra","AKS_74_kobra","AKS-74 PSO","AKS_74_pso","AKS-74U","AKS_74_U","AKS-74UN Kobra","AKS_74_UN_kobra","Bizon PP-19","bizon","Bizon PP-19 SD","bizon_silenced","G36","G36a","G36C","G36C","G36C Eotech SD","G36_C_SD_eotech","G36K","G36K","M1014","M1014","M16A2","M16A2","M16A2 / M203","M16A2GL","m16a4","m16a4","M16A4 / M203","M16A4_GL","M16A4 / M203 RCO","M16A4_ACG_GL","M16A4 RCO","m16a4_acg","M4A1","M4A1","M4A1 / M203 Holo","M4A1_HWS_GL","M4A1 / M203 Holo Camo","M4A1_HWS_GL_camo","M4A1 / M203 Holo SD","M4A1_HWS_GL_SD_Camo","M4A1 / M203 RCO","M4A1_RCO_GL","M4A1 CCO","M4A1_Aim","M4A1 CCO Camo","M4A1_Aim_camo","M4A1 CCO Camo SD","M4A1_AIM_SD_camo","MP5A5","MP5A5","MP5SD6","MP5SD","Saiga 12K","Saiga12K","VSS Vintorez","VSS_vintorez","XM8 Carabine","m8_carbine","XM8 Carabine / M203","m8_carbineGL","XM8 Compact","m8_compact","MG36","MG36","Mk 48 Mod 0","Mk_48","M240","M240","M249","M249","Pecheneg","Pecheneg","PK","PK","RPK-74","RPK_74","XM8 Automatic Rifle","m8_SAW","CZ 550 Scoped","huntingrifle","DMR","DMR","KSVK","KSVK","m107","m107","M24","M24","M40A3","M40A3","Mk12 SPR","M4SPR","SVD","SVD","SVD Camo","SVD_CAMO","XM8 Sharpshooter","m8_sharpshooter","M1911A1","Colt1911","M9","M9","M9 Silenced","M9SD","Makarov PM","Makarov","Makarov Silenced","MakarovSD","Igla","Igla","Javelin","Javelin","M136","M136","Metis AT-13","MetisLauncher","RPG-18","RPG18","RPG-7","RPG7V","SMAW","SMAW","Stinger","Stinger","Strela","Strela","Handgrenade","HandGrenade","Handgrenade West","HandGrenade_West","Handgrenade East","HandGrenade_East","Smoke Shell White","SmokeShell","Smoke Shell Red","SmokeShellRed","Smoke Shell Green","SmokeShellGreen","Smoke Shell Yellow","SmokeShellYellow","Smoke Shell Orange","SmokeShellOrange","Smoke Shell Purple","SmokeShellPurple","TimeBomb","TimeBomb","PipeBomb","PipeBomb","Mine","Mine","MineE","MineE","Stone","HandGrenade_Stone"];

primaryAmmo = {
     private ["_i"];
     _i = ammo find tolower ARG0 ;
     ammo select (_i+1) ;
};

secondaryAmmo = {
     private ["_i"];
     _i = glammo find tolower ARG0 ;
     glammo select (_i+1) ;
};

isGrenadeLauncher = {
     private ["_i"];
     _i = grenadeLaunchers find tolower ARG0 ;
     (_i >= 0) ;
} ;

isBasicRifle = {
     private ["_i"];
     _i = basicRifles find tolower ARG0 ;
     (_i >= 0) ;
} ;
isRifle = {
     private ["_i"];
     _i = rifles find tolower ARG0 ;
     (_i >= 0) ;
} ;

isWeapon = {
     private ["_i"];
     _i = allWeapons find tolower ARG0 ;
     (_i >= 0) ;
} ;

isSniperRifle = {
     private ["_i"];
     _i = sniperRifles find tolower ARG0 ;
     (_i >= 0) ;
} ;

isSilenced = {
     private ["_i"];
     _i = silenced find tolower ARG0 ;
     (_i >= 0) ;
} ;

isMachineGun = {
     private ["_i"];
     _i = machineGuns find tolower ARG0 ;
     (_i >= 0) ;
} ;

isExplosive ={
     private ["_i"];
     _i = explosives find tolower ARG0 ;
     (_i >= 0) ;
} ;

isRocket ={
     private ["_i"];
     _i = rockets find tolower ARG0 ;
     (_i >= 0) ;
} ;

getRocketCapacity={
     private ["_i","_r"];
     _i = rocketCapacity find tolower ARG0 ;
     _r = EL(rocketCapacity,_i+1) ;
     _r ;
} ;

addWeaponsToCrate =
{
     private ["_crate","_weps","_w","_a"] ;
     _crate = ARG0 ;
     _weps = ARG1 ;
     {
	  _w = _x ;
	  if ([_w] call isExplosive) then {
	       _crate addMagazineCargo [_w,10] ;
	  } else {
	       _crate addWeaponCargo [_w,5] ;
	       _a = [_w] call primaryAmmo;
	       _crate AddMagazineCargo [_a,45] ;
	       if ([_w] call isGrenadeLauncher) then {
		    _crate AddMagazineCargo [[_w] call secondaryAmmo,40];
	       };
	  } ;
     } foreach _weps ;
};

weaponMag = {
     private ["_w","_r"] ;
     _w = ARG0;
     _r = ["",""] ;
     _r set [0, [_w] call primaryAmmo] ;
     if ([_w] call isGrenadeLauncher) then {
	  _r set [1,[_w] call secondaryAmmo];
     } ;
     _r ;
} ;



eastWeapons= ["ak_107_kobra","ak_107_gl_kobra","ak_107_gl_pso","ak_107_pso","ak_74","ak_74_gl","ak_47_m","ak_47_s","aks_74_kobra","aks_74_pso","aks_74_u","aks_74_un_kobra","bizon","bizon_silenced","saiga12k","vss_vintorez","pecheneg","pk","rpk_74","huntingrifle","ksvk","svd","svd_camo","makarov","makarovsd","igla","metislauncher","rpg18","rpg7v","strela","handgrenade_east"] ;


weaponSide={
     private ["_r"] ;
     if (ARG0 in eastWeapons) then {_r=east;} else {_r=west;} ;
     _r ;
} ;
