
//Do nothing if we are on the server


#include "lib\common.h" ;


/* if we're not on the server, create a set of regions to represent borders 
   and spawn protection
*/

if (isServer) then {
     
     VAR_DEFAULT(CTF_borderSign,"Sign_1L_Border") ;
     VAR_DEFAULT(CTF_borderHalfLife,10) ;
     
     borderActions=[
	  ["halflife","setnum",CTF_borderHalfLife],
	  ["sign","setstring",CTF_borderSign],
	  ["signspacing","setNum",10],
	  ["nowarn","settrue",false]
	  ] ;
     
     
     createborders={
	  private ["_s","_r","_borders"] ;
	  _borders=[] ;
	  {
	       
	       _s = [_x]  call getRegionAndModifiers ;
	       _r = [_s,borderActions,false] call handleActions ;
	       
	       [_r,markerPos "centerMap"] call makeRegionSemiPlane ;
	       
	       [ _r getVariable "marker","ColorRed","DiagGrid","Mines!", "mil_warning"] call colourAndAddLabel ;
	       
	       _borders = _borders + [_r] ;
	  } foreach (["border"] call findMarkers) ;
	  
	  //Add playzones.
	  //These are just like inverted borders !
	  
	  {
	       _s = [_x]  call getRegionAndModifiers ;
	       _r = [_s,borderActions,false] call handleActions ;
	       
	       [_r] call makeRegionInverted ;
	       
	       //place markers around the playfield
	       [_r,_r getVariable "sign"] call markRegion;
	       //The map marking is a bit different for playzones
	       [ _r getVariable "marker","ColorGreen","DiagGrid","Play Zone", "mil_objective"] call colourAndAddLabel ;
	       
	       _borders = _borders + [_r] ;
	  } foreach (["playZone"] call findMarkers) ;
	  PUBLISH(borders,_borders) ;
     } ;
     
     call createborders ;
} ;

if (not isNull player) then {
     
     borderTask ={
	  private ["_warnTime","_plr","_dowarn","_r","_lastplrpos","_h","_unlucky"];
	  _r = ARG0 ;
	  
	  _warnTime = -10 ;
	  _h = _r getVariable "halflife" ;
	  _dowarn = not (_r getVariable "nowarn") ;
	  _lastplrpos = position player ;
	  //if the player has run out of respawns, they'll be placed
	  //off the map so we better not kill them again
	  while {not playerInterned} do {
	       waituntil {alive player} ;
	       _plr = position player ;
	       //borders only affect those off the ground
	       //we've spawned a separate task to handle the ground
	       //side of things
	       if (EL(_plr,2) > 5) then {
		    if  ([_r,_plr] call insideRegion) then {
			 
			 if (_dowarn and (time - _warnTime > 10)) then {
			      titletext ["DANGER - you are outside the border  !","Plain down"] ;
			      _warnTime= time ;
			 } ;
			 
			 _unlucky = [_h,_plr distance _lastplrpos] call halfLifeExpired ;
			 if (_unlucky) then {  
			      player call blowUp ;
			      titletext ["You moved outside the border","Plain down"] ;} 
		    } ;
	       };
	       _lastplrpos = _plr ;
	       sleep 0.2 ;
	  };
     } ;
     
     
     posOutsideBorder={
	  private ["_pos","_r"] ;
	  _pos = ARG0 ;
	  _r = false ;
	  {
	       if ([_x,_pos] call insideRegion) exitwith {_r=true;} ;
	  } foreach (borders) ;
	  _r ;
     } ;


     [] spawn {
	  borders = RECEIVE(borders) ;
	  
	  {
	       //treat borders as having separate minefield tasks 
	       //this is slightly less efficient than checking inside them once

	       //place markers around the border
	       [_x,VAR(_x,sign)] call markRegion;
	       
	       [_x] spawn {_this call minefieldTask;} ; 
	       [_x] spawn {_this call borderTask;} ; 
	       
	  } foreach borders ; 
     } ;
};
