
//Do nothing if we are on the server


#include "lib\common.h" ;


/* if we're not on the server, create a set of regions to represent borders 
   and spawn protection
*/


ourSpawns = [] ;
theirSpawns = [] ;
punishPlayer=nullObj ;
if (isServer) then {
     
     VAR_DEFAULT(CTF_spawnSign,"Sign_Checkpoint") ;
     
     spawnActions=[
	  ["sign","setString",CTF_spawnSign]
	  ] ;
     
     createSpawn={
	  private ["_s","_r"] ;
	  _s = [ARG0] call getRegionAndModifiers ;
	  _r = [_s,spawnActions,false] call handleActions ;
	  [ARG0,"ColorGreen","FDIAGONAL","",""] call colourAndAddLabel ;
	  _r ;
     } ;
     
     
     
     createSpawns = {
	  private ["_e","_w"];
	  _w = [] ;
	  _e = [] ;
	  
	  { _w=_w + [ [_x] call createSpawn ] ;  
	  } foreach (["wSpawn"] call findMarkers) ;
	  
	  {_e=_e +  [[_x] call createSpawn] ; 
	  } foreach (["eSpawn"] call findMarkers) ;
	  //TODO - should we take a copy of the array ? 
	  PUBLISH(eastSpawns,_e) ;
	  PUBLISH(westSpawns,_w) ;
     } ;
     
     call createSpawns ;
     
     ["respawn_west","ColorBlue","FDIAGONAL","West","mil_Start"] call colourAndAddLabel ;
     ["respawn_east","ColorRed","FDIAGONAL","East","mil_Start"] call colourAndAddLabel ;
     
} ;

if (not isNull player) then {
     blowUp = {
	  private ["_o","_bmb"] ;
	  _o = vehicle _this ;
	  // important - only set off bombs for players at ground level
	  // players in parachutes or in aircraft should not be affected
	  //make sure that even if the grenade misses, we cause serious damage
	  _this setDamage (damage _this) + 0.6 ;
	  if ((position _o select 2) < 1) then {
	       _bmb = "Grenade" createVehicle position _o ; 
	       _bmb setPos (_o modelToWorld [0,0,0]) ;
	       _bmb setDamage 1 ;
	  } ;
     } ;
     
/*
  WHEN a player is hit or killed, check to see whether either they were inside
  their own spawn or else the killer was inside their spawn
*/
     VAR_DEFAULT(CTF_disableFriendlyFire,false) ;

     spawnCheck = {
	  private ["_illegal","_kpos","_plr","_killer"];
	  _killer = _this  ;
	  _illegal = false ;
	  if (not isNull _killer) then {
	       _plr = position player ;
	       _kpos = position _killer;
	       
	       //Check whether we were inside our spawn
	       {
		    _illegal = _illegal or  ([_x,_plr] call insideRegion) ;
	       } foreach ourSpawns ;
	       
	       //Check whether they were inside their spawn
	       {
		    _illegal = _illegal or  ([_x,_kpos] call insideRegion) ;
	       } foreach theirSpawns ;
	       
	       if (_illegal) then {player setDamage 0 ;} ;
	  } ;
	  _illegal ;
     } ;
     
     spawnCheckKill = {
	  private ["_killer"] ;
	  _killer = _this ;
	  illegalKill = false ;
	  punishMsg="Please don't shoot into or out of spawn" ;
	  if (_killer != player)  then {
	       illegalKill =  _this call spawnCheck;
	       
	       
	       if (CTF_disableFriendlyFire) then {
		    if (side _killer == playerSide) then {
			 illegalKill = true ;
			 punishMsg="Please don't shoot your teammates" ;
		    } ;
	       };
	  } ;
	       

	  if (illegalKill) then {
	       //nasty hack code - broadcast killer 
	       //only works for one player at a time obviously !
	       punishPlayer=_this ;
	       publicVariable "punishPlayer" ;
	       publicVariable "punishMsg" ;
	  } ;
     };
     
     
     
//can be called from external code to see whether this position is actually in the playable area 
     posInEnemySpawn ={
	  private ["_pos","_r"] ;
	  _pos = ARG0 ;
	  _r = false ;
	  {
	       if ([_x,_pos] call insideRegion) exitwith {_r=true;} ;
	  } foreach (theirSpawns) ;
	  _r ;
     } ;
     
     spawnTask ={
	  private ["_plr"];
	  if (playerSide== east) then {
	       ourSpawns = RECEIVE(eastSpawns);
	       theirSpawns =RECEIVE(westSpawns) ;
	  } else {
	       ourSpawns = RECEIVE(westSpawns) ;
	       theirSpawns =RECEIVE(eastSpawns);
	  } ;
	  {
	       [_x,VAR(_x,sign)] call markRegion;
	  } foreach (ourSpawns+theirSpawns) ;
	  //The chance of the dying is exponential with distance 
	  //since p(alive) = 1/x * 1/x* 1/x etc 
	  //The seed probability is calculated from CTF_minefieldHalfLife
	  //Default value is 50% probability of death for every 10m
	  while {not gameOver} do {
	       waituntil {alive player} ;
	       _plr = position player ;
	       
	       //Check to see if we are in our spawn
	       {
		    if ( [_x,_plr] call insideRegion) then {
			 if (not isNull flag player) then {[flag player,"The flag was taken into spawn"] call forceReturn;} ; 
		    } ;
		    sleep 0.1 ;
	       }  foreach ourSpawns ;
	       
	       //Check to see if we are in their spawn but allow us to overfly it
	       {
		    
		    if ( (alive player) and ([_x,_plr] call insideRegion) and (EL(_plr,2)<1)) then {
			 
			 player call blowUp ; } ;
		    sleep 0.1 ;
	       }  foreach theirSpawns ;
	       
	       sleep 0.1 ;
	  } ;
     } ;
     
     badBoytask ={
	  while {true} do {
	       waituntil {punishPlayer == player} ;
	       punishPlayer = nullObj ;
	       titleText [punishMsg,"BLACK FADED"] ;
	       player setDir random 360 ;
	  sleep 7 ;
	       titleText [punishMsg,"BLACK IN",1] ;
	       
	  } ;
     };
     
     
     //Add event handlers to check for spawn kills 
     player addEventHandler ["HIT",{_this select 1 call spawnCheck}];
     player addEventHandler ["KILLED",{_this select 1 call spawnCheckKill}];
     
     
     
     
     [] spawn {[] call spawnTask ;} ;
     [] spawn {[] call badBoyTask ;} ;
} ;
     
