
#include "common.h" ;

// Parameters [position or object,range1,(range2)] 
// returns a random position within range1 and range2 of the unit 
// if range2 is not supplied, it is assumed that it is equal to range1


randPos = {
     private ["_o","_t","_pos","_minr","_maxr","_d","_az","_px","_py"] ;
     _o = _this select 0 ;
     _t = typeName (_o) ;
     _pos =[];
     if (_t == "ARRAY") then {
	  _pos = _o ;
     };
     if (_t == "OBJECT") then {
	  _pos = position _o ;
     };
     _minr = _this select 1 ; 
     // work out  random range
     
     _d = _minr ;
     if (count _this > 2) then {
	  _maxr = _this select 2 ; 
	  _d = _minr + random (_maxr - _minr) ;
     } ;

     //pick a random direction
     _az = random 360 ;
     
     //pick a point in that area
     _px = (_pos select 0) + _d * sin (_az);
     _py = (_pos select 1) + _d * cos (_az) ;
     
//return 
     [_px,_py] ;
} ;


//flips pos2 180 degrees around pos1 

flipPos = {
     private ["_origin","_pos"] ;
     _origin = _this select 0 ;
     _pos = _this select 1 ;
     [   2* (_origin select 0) - (_pos select 0),
	 2* (_origin select 1) - (_pos select 1)
     ];
} ;


/*
  Rotate pos1 around pos2 by x degrees 
*/


rot = {
     private ["_pos1","_pos2","_theta","_dx","_dy","_nx","_ny"] ;
     _pos1 = _this select 0 ;
     _pos2 = _this select 1 ;
     _theta = _this select 2 ;
     _dx = (_pos1 select 0) - (_pos2 select 0) ;
     _dy = (_pos1 select 1) - (_pos2 select 1) ;
     
     _nx = (_dx * cos _theta) + (_dy * sin _theta) ; 
     _ny =  (_dy * cos _theta)-(_dx * sin _theta)  ; 
     
   [_nx + (_pos2 select 0),_ny+(_pos2 select 1)] ;
} ;


//return the position half way between two points 

midpoint = {
     [(EL(EL(_this,0),0) + EL(EL(_this,1),0))/2,
      (EL(EL(_this,0),1) + EL(EL(_this,1),1))/2
       ] ;
} ;

//returns the vector from pos2 to pos1 
// ie pos1-pos2

subtractPos ={
     private ["_pos1","_pos2"] ;
     _pos1 = _this select 0;
     _pos2 = _this select 1;
     [EL(_pos1,0) - EL(_pos2,0),  EL(_pos1,1)-EL(_pos2,1)] ;     
} ;


//adds a vector to a position
//ie pos1+v1

addPos={
     private ["_pos1","_pos2"] ;
     _pos1 = _this select 0;
     _pos2 = _this select 1;
     [EL(_pos1,0) + EL(_pos2,0),  EL(_pos1,1)+EL(_pos2,1)] ;     
} ;

//returns the direction from pos1 to pos2

bearing = {
     private ["_pos1","_pos2","_v","_b"] ;
     _pos1 = _this select 0;
     _pos2 = _this select 1;
     _v= [_pos2,_pos1] call subtractPos ;
     _b = (EL(_v,0) atan2 EL(_v,1))  ;
     _b = (360+_b) % 360 ;
     _b ;
     
} ;
    
//returns the relative bearing from pos1 to pos2 
relativeBearing={
     private ["_o","_b"] ;
     _o = ARG0 ;
     _b = [getPos _o,ARG1] call bearing;
     _b = _b - (getDir _o) ;
     if (_b > 180) then { _b = 360 - _b ;} ;
     if (_b < -180) then { _b = 360 + _b ;} ;
     _b ; 
} ;


scale ={
     private ["_pos","_n"];
     _pos = ARG0;
     _n = ARG1 ;
     [(_pos select 0)*_n,(_pos select 1)*_n] ;
} ;

//calculate the center of gravity of a number of supplied objects or positions
getCoG ={
     private ["_acc","_t","_pos"];
     
     _acc = [0,0,0] ;
     {   
	  _t = typeName (_x) ;
	  _pos =[];
	  if (_t == "ARRAY") then {
	       _pos = _x;
	  };
	  if (_t == "OBJECT") then {
	       _pos = position _x ;
	  };
	  _acc =  [_acc,_pos] call addPos ;
     } foreach _this ;
     _acc = [_acc,1/(count _this)] call scale ;
     _acc ;
} ;
