/*
  Various utility functions to help with sides
*/
#include "common.h" ;

sideInfo=[east,"east",[west],west,"west",[east],sideenemy,"enemy",[friendly],
	  civilian,"civ",[enemy],resistance,"guer",[west],
	  sidefriendly,"friendly",[enemy]] ;


otherSide = {
     private ["_r"];
     _r = sideInfo find ARG0 ;
     _r = EL(EL(sideInfo,_r+2),0);
} ;

sideToStr = {
     private ["_r"];
     _r = ARG0 ;
     if (typename _r =="SIDE") then {
	  _r = sideInfo find ARG0 ;
	  _r = EL(sideInfo,_r+1);
     } ;
     _r ;
} ;

sideName = {
     private ["_r"];
     switch (_this) do {
     case west : {_r = "USA" ;} ;
     case east : {_r = "USSR" ;} ;
     } ;
     _r ;
} ;

strToSide = {
     private ["_r"];
     _r = ARG0 ;
     if (typename _r =="STRING") then {
	  _r = sideInfo find ARG0 ;
	  _r = EL(sideInfo,_r-1);
     } ;
     _r ;
} ;

sideColour={
     private ["_r"] ;
     _r = "ColorBlack" ;
     if(ARG0==east ) then {_r="ColorRed";} ;
     if(ARG0==west ) then {_r="ColorBlue";} ;
     _r ;
} ;


//compares two sides regardless of whether they are strings or real sides
sidesEqual={
     private ["_s1","_s2"] ;
     _s1 = [ARG0] call sideToStr ;
     _s2 = [ARG1] call sideToStr ;
     _s1 == _s2 ;
} ;
