

#include "lib\common.h" ;


/* if we're not on the server, create a set of regions to represent borders 
   and spawn protection
*/


if (isServer) then {
     
     VAR_DEFAULT(CTF_minefieldSign,"Sign_1L_Noentry") ;
     VAR_DEFAULT(CTF_minefieldHalfLife,10) ;

     minefieldActions=[
	  ["halflife","setnum",CTF_mineFieldHalfLife],
	  ["sign","setstring",CTF_minefieldSign],
	  ["signspacing","setNum",10],
	  ["nowarn","settrue",false]
	  ] ;
     
     
     createMinefields={
	  private ["_s","_r","_mines"] ;
	  _mines = [] ;
	  {
	       _s = [_x]  call getRegionAndModifiers ;
	       _r = [_s,minefieldActions,false] call handleActions ;
	       //colour in the minefield on the map 
	       if ((_r getVariable "label") == "") then {
		    [_r getVariable "marker","ColorRed","DiagGrid","Mines!","mil_warning"] call colourAndAddLabel ;
	       } ;
	       _mines=_mines + [_r] ;
	  } foreach (["minefield"] call findMarkers) ;
	  PUBLISH(minefieldList,_mines) ;
     } ;
     
     [] spawn {call createMinefields ; } ;
} ;

if (not isNull player) then {
     minefieldTask ={
	  private ["_warnTime","_plr","_lastplrpos","_dowarn","_r","_h","_unlucky","_freePass","_zz"];
	  _r = ARG0 ;
	  _warnTime = -10 ;
	  waitUntil {GameStarted} ;
	  _lastplrpos = position player ;
	  _h = _r getVariable "halflife" ;
	  _dowarn = not (_r getVariable "nowarn") ;
	  while {not playerInterned} do {
	       waituntil {alive player} ;
	       _plr = position player ;
	       //Minefilds only affect those on the ground
	       if ([_r,_plr] call insideRegionOnGround) then {
		    
		    if (_dowarn and (time - _warnTime > 10)) then {
			 titletext ["DANGER - MINES !","Plain down"] ;
			 _warnTime= time ;
		    } ;
		    _freePass = false ;
		    {
			 if ([_r,_x] call insideRegion) then {
			      _zz = [_r,_x] call nearestEdgePoint ;
			      if ((_plr distance _zz) < ((_zz distance _x) + 3)) then {
				   //this is a free pass into the minefield !
				   _freePass = true ;
			      } ;
			 } ;
		    } foreach droppedFlags ;
		    if (not _freePass) then {
			 _unlucky = [_h,_plr distance _lastplrpos] call halfLifeExpired ;
			 if (_unlucky) then {  
			      player call blowUp ;
			      titletext ["You stepped on a mine - watchout for the edge of the minefield","Plain down"] ;
			 } ;
		    } ;
	       };
	       _lastplrpos = _plr ;
	       sleep 0.2 ;
	  };
     };     
     
     posInMinefield={
	  private ["_pos","_r"] ;
	  _pos = ARG0 ;
	  _r = false ;
	  {
	       if ([_x,_pos] call insideRegion) exitwith {_r=true;} ;
	  } foreach (minefields) ;
	  _r ;
     } ;
     
     
     [] spawn {
	  minefields = RECEIVE(minefieldList);
	  {
	       //place markers around the minefield
	       [_x,VAR(_x,sign)] call markRegion;

	       [_x] spawn {_this call minefieldTask;} ; 
	  } foreach minefields ; 
     } ;
} ;

