
#include "lib\common.h"

if (isNull player) exitwith {} ;

VAR_DEFAULT(CTF_allowSilencedWeapons,false);
VAR_DEFAULT(CTF_allowSniperRifles,false);
VAR_DEFAULT(CTF_allowGrenadeLaunchers,false);
VAR_DEFAULT(CTF_allowMachineGuns,false);

crateActions=[
     ["crate","setString","RUSpecialWeaponsBox"],
     ["east","setTrue",false],
     ["west","setTrue",false],
     ["norifles","setTrue",false],
     ["sniper","setTrue",CTF_allowSniperRifles],
     ["silenced","setTrue",CTF_allowSilencedWeapons],
     ["gl","setTrue",CTF_allowGrenadeLaunchers],
     ["mg","setTrue",CTF_allowMachineGuns],
     ["rockets","setTrue",false],
     ["pistols","setTrue",false],
     ["all","setTrue",false]
     ] ;


//FIX FIX - use modifiers !
createAmmoCrateFromMarker = {
     private ["_m","_a","_r","_weapons","_filter","_s","_weps","_state","_gearList","_use"] ;

     _m = ARG0 ;
     _weapons = ARG1 ;
     _filter = ARG2;

     _s = [_m] call getRegionAndModifiers ;
     _r = [_s,crateActions] call handleActions ;

     _a = VAR(_r,crate) createVehicleLocal VAR(_r,center) ;
     _a setPos VAR(_r,center) ;
     _a setDir VAR(_r,dir) ;
     clearWeaponCargo _a ;
     clearMagazineCargo _a ;
     _weps = [] ;
     {
	  _use = false ;
	  if (([_x] call isbasicRifle) and not VAR(_r,norifles)) then {_use = true ;} ;
	  if (([_x] call isSilenced) and VAR(_r,silenced)) then {_use = true ;} ;
	  if (([_x] call isSniperRifle) and VAR(_r,sniper)) then {_use=true;} ;
	  if (([_x] call isGrenadeLauncher) and VAR(_r,gl)) then {_use=true;} ;
	  if (([_x] call isMachineGun) and VAR(_r,mg)) then {_use=true;} ;
	  if (([_x] call isRocket) and VAR(_r,rockets)) then {_use=true;} ;
	  if (VAR(_r,all)) then {_use=true;} ;
	  _s = [_x] call weaponSide ;
	  if (VAR(_r,east) and (_s != east)) then {_use=false ;} ;
	  if (VAR(_r,west) and (_s != west)) then {_use=false ;} ;


	  if (_use) then {_weps = _weps + [_x] ;} ;

     } foreach allWeapons ;
     
     [_a,_weps] call addWeaponsToCrate ;
     _a allowDamage false ;
     _a ;
} ;

crateList = [];
{
     
     _a = [_x,allRifles,true] call createAmmoCrateFromMarker ;
     crateList = crateList + [getPos _a] ;
     [_x] call JIPSafedeleteMarker ;
} foreach (["ammo"] call findMarkers) ;



[] spawn {
     _state = "waiting" ;
     _gearList =["amovpercmstpsraswrfldnon_gear","amovpknlmstpsraswrfldnon_gear"] ;
     while {true} do  {

	  switch (_state) do {
	  case "waiting": {
	       if ((animationState player) in _gearList) then {
		    {
			 //3.2 seems to be about the maximum distance you can grab gearfrom
			 if (_x distance player < 3.2) then {
			      _state="gear" ;
			 };
		    }  foreach crateList ;
	       } ;
	  } ;
	  case "gear": {
	       if (not ((animationState player) in _gearList)) then { 
		    hint "Loadout saved" ;
		    call updatePlayerLoadout ;
		    _state="waiting" ;
	       } ;
	  };
	  } ; //switch
	  sleep 1 ;
     };
} ;
