
#include "common.h" ;
//return a list of all markers starting with the supplied prefix
//ideally we would search the entire namespace but that's not feasible
//at the moment so we limit ourselves to markers named x, x_1, ... x_99

cleanupList = [] ;
cleanupMarkers={
     { 
	  deleteMarker _x ;
     } foreach cleanupList ;
} ;
findMarkers ={
     private ["_c","_prefix","_name","_ret"];
     _prefix = ARG0;
     _ret=[];
     for "_c" from -1 to 100 do {
	  _name = _prefix ;
	  if (_c >=0) then {
	       _name = _name + format ["_%1",_c];
	  } ;
	  if (getMarkerType _name  != "") then {
	       _ret=_ret + [ _name];
	  } ;
     } ;
     cleanupList = cleanupList+_ret ;
     _ret ;
};

//dynamically-created marker state is not broadcast for JIP players 
//so we need to keep a list of markers and refresh them when players join

JIPmarkers= [] ;
JIPDeletedmarkers= [] ;


addJIPsafeMarker ={
     if (isserver) then {
	  if (JIPmarkers find ARG0 < 0) then {
	       JIPmarkers = JIPmarkers + [ARG0] ;
	  } ;
	  
	  JIPDeletedMarkers = JIPDeletedmarkers - [ARG0] ;
     } ;

} ;

JIPSafedeleteMarker={
     private ["_m"];
     _m = ARG0 ;
     if (not isNull player) then {
	  deleteMarkerLocal _m;
     } else
     {

	  if (JIPDeletedmarkers find _m < 0) then {
	       //deleteMarker _m;
	       JIPDeletedmarkers = JIPdeletedMarkers +[_m] ;
	       publicVariable "JIPDeletedMarkers" ;
	  } ;
	  JIPmarkers =JIPmarkers -[_m];
     } ;
} ;


servermarkerDel={
     while {not gameOver} do {
	  publicVariable "JIPDeletedMarkers" ;
	  sleep 5 ;
     } ;
} ;

clientMarkerDel={
     while {not gameOver} do {
	  waituntil {count JIPDeletedMarkers >0;} ;
	  {
	       deleteMarkerLocal _x ;
	  } foreach JIPDeletedMarkers ;
	  JIPDeletedMarkers=[] ;
	  sleep 1;
     } ;
} ;

if (not isserver) then {
     [] spawn {call clientMarkerDel;} ;
} ;

JIPrefreshMarkers={
     {
	  _x setMarkerShape markerShape _x;
	  _x setMarkerType markerType _x;
	  _x setMarkerColor markerColor _x;
	  _x setMarkerPos markerPos _x;
	  _x setMarkerDir markerDir _x;
	  _x setMarkerSize markerSize _x;
	  _x setMarkerText markerText _x;
     } foreach JIPmarkers ;

     publicVariable "JIPDeletedMarkers" ;
} ;

JIPsafeCreateMarker = {
     private ["_m","_pos"];
     _m= ARG0;
     _pos = ARG1;
     _m = createMarker [_m,_pos] ; 
     [_m] call addJIPsafeMarker ;
     _m ;
} ;

//text, position, icon type
labelCount =0 ;
addLabel={
     private "_l" ;
     labelCount=labelCount+1 ;
     _l = format ["label %1 %2",time,labelCount] ;
     if (isServer) then {
	  _l = [_l,ARG1] call JIPsafeCreateMarker ;
	  _l setMarkerColor "ColorBlack" ;
	  _l setMarkerShape "ICON" ;
	  _l setMarkerType ARG2 ;
	  _l setMarkerText ARG0;
     } else {
	  _l = createMarkerLocal[_l,ARG1]  ;
	  _l setMarkerColorLocal "ColorBlack" ;
	  _l setMarkerShapeLocal "ICON" ;
	  _l setMarkerTypeLocal ARG2 ;
	  _l setMarkerTextLocal ARG0;
     } ;
     _l ;
} ;


// Marker, colour,style,labletext,labelstyle
colourAndAddLabel ={
     private ["_mkr","_col","_style","_text","_mrkStyle"];
     _mkr = ARG0 ;
     _col = ARG1 ;
     _style = ARG2 ;
     _text = ARG3 ;
     _mrkStyle=ARG4;
     if (isServer) then {
	  [_mkr] call addJIPsafeMarker ;
	  _mkr setMarkerColor _col;
	  _mkr setMarkerBrush _style;
     } else {
	  _mkr setMarkerColorLocal _col;
	  _mkr setMarkerBrushLocal _style;
     } ;
     
     if (_text != "") then {
	  [_text,markerPos _mkr,_mrkStyle] call addLabel ;
     } ;
} ;


checkForMissingMarkers={
     {
	  if (getmarkerType _x == "") then {
	       ["Required marker '" + _x + "' not found."] call logError ;
	  } ;
     } foreach _this;
} ;
