
#include "lib\common.h" ;

mmList =[] ;

findModifierMarkers={
     private ["_r","_m","_mm","_allModifiers","_t","_i"];
     _r = ARG0 ;
     _m=ARG1;
     //should really cache this result
     _allModifiers = [""] call findMarkers ;
     _mm=[] ;
     {
	  if ([_r,markerPos _x] call insideRegion) then 
	       {
		    _mm= _mm + [_x] ;
		    _i = mmList find _x ;
		    if (_i >=0) then {
			 _t = EL(mmList,_i+1) ;
			 _t = _t + [_m] ;
		    } else {
			 mmList =mmList + [_x,[_m]] ;
		    } ;
	       } ;
     } foreach _allModifiers ;
     _mm ;
} ;

getModifiersForMarker={
     private ["_marker","_modifiers","_tokens","_text","_values","_a","_markerList"];
     _marker = ARG0 ;
     _text = markerText _marker;
     _values=[];
     _modifiers=[];
     _markerList=[] ;
     _tokens = [_text,","] call strSplit ;
     {
	  _a = [_x,"="] call strSplit ;
	  _modifiers =_modifiers + [EL(_a,0)] ;
	  if (count _a > 1) then {
	       _values = _values + [EL(_a,1)] ; 
	  } else{
	       _values = _values + [""] ; 
	  };
	  _markerList =_markerList +[_marker] ;
     } foreach _tokens;
     [_modifiers,_values,_markerList] ;
} ;



getRegionAndModifiers={
     private ["_r","_m","_a","_modMarkers","_modifiers","_markerList","_values"];
     _m = ARG0 ;
     if (markerShape _m == "ICON") then {
	  _r =[markerPos _m,[5,5],markerDir _m,"ELLIPSE"] call createRegion ;
	  _r setVariable ["marker",_m,true];
     } else {
	  _r = [_m] call createRegionFromMarker ;
     } ;
     
     _modMarkers = [_m] ;
     if (count _this < 2) then {
	  _modMarkers = _modMarkers +  ([_r,_m] call findModifierMarkers) ;
     } ;
     _modifiers = [] ;
     _values=[] ;
     _markerList =[] ;
     {
	  _a = [_x] call  getModifiersForMarker ;
	  _modifiers = _modifiers + EL(_a,0) ;
	  _values = _values + EL(_a,1) ;
	  _markerList = _markerList + EL(_a,2) ;
     } foreach _modMarkers ;
     //return array [_r,[strings],[vals],[owner markers]] here
     [_r,_modifiers,_values,_markerList];
} ;

//asumes it is passed the returned struct from getregionandmodifierstrigs
getModifierMarker={
     private ["_string","_struct","_n","_list"];
     _struct=ARG1 ;
     _string=ARG0 ;
     _n = EL(_struct,1) find _string ;
     _list = EL(_struct,3) ;
     EL(_list,_n) ;
} ;

getModifierValue={
      private ["_string","_struct","_n"];
     _struct=ARG1 ;
     _string=ARG0 ;
     _n = EL(_struct,1) find _string ;
     EL(EL(_struct,2),_n) ;
};

getModifierValueNum={
     private "_v" ;
     _v = _this call getModifierValue;
     parseNumber _v ;
};


handleActions={
     private ["_mrk","_r","_s","_keys","_i","_name","_modifier","_action","_actions","_modifiers","_l","_unrecognisedKeywords","_str"];
     _s =ARG0 ;
     _keys = [] ;
     _actions=[] ;

     _r = EL(_s,0) ;
     _modifiers=EL(_s,1) ;
     
     {
	  _keys = _keys + [tolower EL(_x,0)] ;
	  _actions = _actions + [EL(_x,1)] ;
	  //set default values for variables
	  if (count _x >2) then {
	       _r setVariable[EL(_x,0),EL(_x,2),true] ;
	  } ;
     } foreach ARG1 ;

     _unrecognisedKeywords =[];
     {
	  _modifier = _x ;
	  _i = _keys find toLower _modifier ;
	  if (_i >=0) then {
	       _action = EL(_actions,_i) ;
	       switch (typeName _action) do {
	       case "STRING" : {
		    switch (toLower _action) do {
		    case "setstring" : {
			 _r setVariable [_modifier,[_modifier,_s] call getModifierValue,true] ;
		    } ;
		    case "setnum" : {
			 _r setVariable [_modifier,[_modifier,_s,true] call getModifierValueNum,true] ;
		    } ;
		    case "settrue" : {
			 _r setVariable [_modifier,true,true] ;
		    };
		    case "setfalse" : {
			 _r setVariable [_modifier,false,true] ;
		    } ;
		    } ;
	       } ;
	       case "CODE" :{
		    call _action ;
	       } ;
	       } ;//switch
	       
	  } else {
	       _unrecognisedKeywords=_unrecognisedKeywords+[_modifier] ;
	  } ;
	  
     } foreach _modifiers ;
     
     _name = EL(_modifiers,0) ;
     _unrecognisedKeywords = _unrecognisedKeywords - [_name] ;
     _mrk = [_name,_s] call getModifierMarker ;
     
     if (count _unrecognisedKeywords>0) then {
	  {
	       ["Unrecognised keyword '" + _x + "' in marker " + _mrk] call logError ;
	  } foreach _unrecognisedKeywords;
	  ["Valid keywords are..."] call logError ;
	  _str = "" ;
	  {_str = _str+" "+_x ;} foreach  _keys;
	  [_str] call logError ;
     };
      SETVARP(_r,label,"") ;
     if ((_name != "") and (not ((tolower _name) in _keys))) then {
	  SETVARP(_r,name,_name) ;
	  if (markerShape _mrk == "ICON") then {
	       _mrk setMarkerText _name ;
	       if (markerType _mrk == "EMPTY") then {
		    _mrk setMarkerType "Dot" ;
	       } ;
	       _mrk setMarkerColorLocal "ColorBlack" ;
	        SETVARP(_r,label,_mrk) ;

	  } else {
	       _l=[_name,markerPos _mrk,"Dot"] call addlabel ;
	        SETVARP(_r,label,_l);
	  } ;
     } else {
	  SETVARP(_r,name,"") ;

	  //pass in false as 3rd arg to stop original marker being deleted
	  if (count _this >2) then {
	  }    else {
	       [_mrk] call JIPSafeDeleteMarker
	  } ;
     } ;
     _r ;
} ;

removeModifiers={
     private ["_m","_owners","_i"];
     if (isServer) then {
	  {
	       _m = _x ;
	       //error checking....
	       _i = mmList find _m ;
	       if (_i <0) then {
		    ["Modifier "+_m+" does not belong to any marker"] call logError ;
	       } else {
		    _owners = EL(mmList,_i+1) ;
		    if (count _owners > 1) then {
			 ["Modifier "+_m+" affects multiple markers:-"] call logError ;
			 {
			      ["   "+_x] call logError ;
			 } foreach _owners ;
		    } ;
	       } ;
	       //removal 
	       [_x] call JIPSafedeleteMarker ;
	  } foreach ([""] call findMarkers) ;
     } ;
} ;


//find a region by markername or 'text' name
//ARG0=name, ARG1 is list of regions
findRegion={
     private ["_r"] ;
     _r =objNull;
     {
	  if (VAR(_x,marker) == ARG0) then {
	       _r = _x ;
	  } ;
	  if (VAR(_x,label) == ARG0) then {
	       _r = _x ;
	  } ;
     } foreach ARG1 ;
     _r ;
} ;
