/*
  Scoring system for CTF type games
*/ 

#include "lib\common.h" ;

/* public variable used by both server and clients */
scoreHint="No score" ;

VAR_DEFAULT(CTF_scoreToWin,100000) ;

/* 
   Functions to handle scores and suitable announcements
   Only used on server
 */

if (isServer) then {
     scoreArray=[0,0,0,0];
     WEST_flags =0 ;
     WEST_touches =0 ;
     EAST_flags =0 ;
     EAST_touches =0 ;
     
     scoreString = {
	  format ["EAST\n   %1 flags, %3 touches\nWEST\n   %2 flags, %4 touches",
		  EAST_flags, WEST_flags,
		  EAST_touches, WEST_touches] ;
	  
     } ;
     
     
     updateScoreHint ={
	  call updateScoreArray ;
     } ;

     updateScoreArray ={
	  scoreArray=[EAST_flags,EAST_touches,WEST_flags,WEST_touches] ;
	  publicVariable "scoreArray" ;
	  if ((EAST_flags >= CTF_scoreToWin) or (WEST_flags >= CTF_ScoreToWin)) then {
	       forceGameOver=true;
	  } ; 
     } ;
     
     flagScore={
	  private ["_plr","_side","_points","_scorePoint"] ;
	  _plr = ARG0 ;
	  _plr addScore 20 ;
	  _side= ARG1 ;
	  _scorePoint=ARG2 ;
	  _points=VAR(_scorePoint,score) ;
	  call compile format ["%1_flags=%1_flags+%2",_side,_points];
	  if (_points ==1) then {
	       [ format ["%1 scored for the %2 side",name _plr, _side],
		 "flagScored"] call announce; 
	  } else {
	       [ format ["%1 scored %2 points for the %3 side",name _plr,_points, _side],
		 "flagScored"] call announce;
	  } ;
	  call updateScoreArray ;
     } ;
     
     flagTaken={
	  private ["_plr","_side"] ;
	  _plr = ARG0;
	  _side= ARG1;
	  _plr addScore 5 ;
	  [ format ["%1 took the flag for the %2 side",name _plr, _side], 
	    "flagTaken"] call announce;
     } ;
     
     flagTouch={
	  private ["_plr","_side"] ;
	  _plr = ARG0;
	  _side= ARG1;
	  _plr addScore 5 ;
	  call compile format ["%1_touches=%1_touches+1",_side];
	  [ format ["%1 scored a flag-touch for the %2 side",name _plr, _side]] call announce;
	  call updateScoreArray ;
     } ;
     
     flagDrop={
	  private ["_side"] ;
	  _side = ARG0  ;
	  [format ["The %1 flag runner was killed",_side]] call announce;
	  call updateScoreArray ;
     };

     stdFlagReturn={
	  private ["_plr","_side","_name"] ;
	  _plr = ARG0 ;
	  _side= ARG1 ;
	  _plr addScore 5 ;
	  if (isNull _plr) then {_name = "Someone";} else {_name= name _plr;};
	  [format ["%1 has returned the flag for the %2 side",_name,_side]] call announce;
	  call updateScoreArray ;
     };

     flagReturn={
	  private ["_plr","_side","_flg"] ;
	  _plr = ARG0 ;
	  _side= [ARG0] call plrSide ;
	  _flg = ARG1 ;
	  [VAR(_flg,returnMsg)] call announce;
     };
     
     flagPickup={
	  private ["_plr","_side"] ;
	  _plr = ARG0 ;
	  _plr addScore 5 ;
	  _side = ARG1 ;
	  [format ["%1 has picked up the flag for the %2 side",name _plr, _side]] call announce;
	  call updateScoreArray ;
     };
     
     flagBeingTracked={
	  ["Flag-tracker enabled"] call announce ;
     } ;

     gameOverScore={
	  private ["_res"];
	  _res = "The game is a draw" ;
	  if ( (WEST_flags>EAST_flags) or 
	      ((WEST_flags == EAST_flags) and (WEST_touches > EAST_touches))
	       ) then {
	       _res = "West wins !" ;
	  } ;
	  if ((WEST_flags<EAST_flags) or 
	      ((WEST_flags == EAST_flags) and (WEST_touches < EAST_touches))
	       ) then {
	       _res = "East wins !" ;
	  };
	  [format ["GAME OVER\n\n%1\n\n%2",_res,call scoreString]] call announceCenter ;
     };

     call updateScoreArray ;
     
} ;     

if (not isNull player) then {

     
     flagHinter={
	  private ["_flgs","_str","_hinted"] ;
	  _flgs = _this ;
	  _hinted=0 ;
	  while {true} do {
	       {
		    if (VAR(_x,nearestPlayer)==player) then {
			 hint format ["Flag return/pick-up in\n%1 seconds",
				      [VAR(_x,nearestPlayerTime)] call cfTimeToGameTime] ;
			 _hinted=1 ;
		    } ;
		    
	       }  foreach _flgs ;
	       if (_hinted ==0) then {hint "";} ;
	       _hinted=_hinted -1 ;
	       sleep 1 ;
	  };
     };
     createFlagHinter = {
	  _this spawn {_this call flagHinter;}; 
     }; 
} ;     

