
//flags are global entities so monitor these on the server

if (not isServer) exitwith{} ;

#include "lib\common.h" ;


/* if we're not on the server, create a set of regions to represent borders 
   and spawn protection
*/


noFlagActions=[
     ["allowEastFlag","setTrue",false],
     ["allowWestFlag","settrue",false],
     ["dontReturnFlag","settrue",false],
     ["dontKill","settrue",false],
     ["halflife","setnum",10],
     ["sign","setString","Sign_1L_Noentry"]
     ] ;


noflags = [] ;

createnoflags={
     private ["_s","_r"] ;
     {
	  _s = [_x]  call getRegionAndModifiers ;
	  _r = [_s,noFlagActions,false] call handleActions ;
	  //place markers around the minefield
	  [_r,_r getVariable "sign"] call markRegion;
	  //colour in the minefield on the map 
	  //_x setMarkerColor "ColorOrange" ;
	  //_x setMarkerBrush "DiagGrid";
	  //,"No flags","mil_warning"] call colourAndAddLabel ;
	  [_r getVariable "marker","ColorOrange","DiagGrid","No flags","mil_warning"] call colourAndAddLabel ;
	  noflags = noflags+ [_r] ;
     } foreach (["noflag"] call findMarkers) ;
} ;


noFlagTask ={
     private ["_r","_h","_unlucky","_flg","_pos","_side","_lastpos","_allowEastFlag","_allowWestFlag","_o"];
     _r = ARG0 ;
     _flg = ARG1 ;
     _lastpos = position _flg ;
     _h = _r getVariable "halflife" ;
     _allowWestFlag = _r getVariable "allowWestFlag" ;
     _allowEastFlag = _r getVariable "allowEastFlag" ;
     while {not gameOver} do {
	  _o = flagowner _flg;
	  if (not isNull _o) then {
	       _pos = position _o ;
	       _side = [_o] call plrSide ;
	  
	       if (   ((_side == east) and (not _allowWestFlag)) or 
		      ((_side == West) and (not _allowEastFlag))  ) then 
		    {
			 if ([_r,_pos] call insideRegion) then {
			      _unlucky = [_h,_pos distance _lastpos] call halfLifeExpired ;
			      if (_unlucky) then {  
				   if (not (_r getVariable "dontreturnflag")) then {
					[_flg,"The flag was taken into a no-flag zone"] call forceReturn ;
				   } ;
				   if (not (_r getVariable "dontkill")) then {
					if (alive _o) then {_o setDamage 1 ; } ;
				   };
			      } ;
			 } ;
		    } ;
	  };
	  _lastpos = _pos ;
	  sleep 1 ;
     };
} ;


call createnoflags ;

private ["_nf"];
{
     
     _nf = _x ;
     {
	  [_nf,_x] spawn {_this call noFlagTask;} ; 
     } foreach flagList ;
} foreach noFlags ; 

