/*
  This file contains all scoring-related functionality
  Note that it is up to other components to decide when scoring
  should take place
*/ 


switch (CTF_gameType) do {
 case "CTF" : {
      call compile preprocessfile "ctf\scoring_ctf.sqf" ;
 } ;
 case "ECL" : {
      call compile preprocessfile "ctf\scoring_ecl.sqf" ;
 } ;
 case "RUGBY" : {
      call compile preprocessfile "ctf\scoring_rugby.sqf" ;
 } ;
 case "DM" : {
      call compile preprocessfile "ctf\scoring_dm.sqf" ;
 } ;
 case "TDM" : {
      call compile preprocessfile "ctf\scoring_tdm.sqf" ;
 } ;
 case "FF" : {
      call compile preprocessfile "ctf\scoring_ff.sqf" ;
 } ;
 case "KOH" : {
      call compile preprocessfile "ctf\scoring_koh.sqf" ;
 } ;
 case "INSURGENCY" : {
      call compile preprocessfile "ctf\scoring_insurgency.sqf" ;
 } ;
 case "C&H" : {
      call compile preprocessfile "ctf\scoring_ch.sqf" ;
 } ;
 case "AAS" : {
      //AAS currently has identical scoring to C&H
      call compile preprocessfile "ctf\scoring_ch.sqf" ;
 } ;
 case "COOP" : {
      call compile preprocessfile "ctf\scoring_coop.sqf" ;
 } ;
} ;


/* create radio triggers to allow players to check the score in various ways*/
if (not isNull player) then {
     private ["_trg"];
     _trg = createTrigger ["EmptyDetector",getPos player];
     _trg setTriggerArea[5,5,0,true];
     _trg setTriggerActivation["ALPHA","PRESENT",true];
     _trg setTriggerStatements["this", "[] call hudToggle;", ""]; 
     1 setRadioMsg "Toggle Score HUD" ;

     [] spawn {[] call hudTask;} ;

};

