#include "lib\common.h"

if (not isServer) exitwith {} ;


//Construct a list of vehicle parks...

carparks =[] ;
respawnVehicleList =[] ;
deadCrew =[] ;
VAR_DEFAULT(CTF_vehicleRespawnDelay,30);
VAR_DEFAULT(CTF_vehicleRepairTime,10);
VAR_DEFAULT(CTF_vehicleOnlyRespawnDamaged,false) ;

carparkActions=[
     ["respawnDelay","setNum",CTF_vehicleRespawnDelay],
     ["repairTime","setNum",CTF_vehicleRepairTime],
     ["dontRepairCars","setTrue",false],
     ["dontRepairTanks","setTrue",false],
     ["dontRepairBikes","setTrue",false],
     ["dontRepairPlanes","setTrue",false],
     ["dontRepairHelicopters","setTrue",false],
     ["onlyRespawnDamaged","setTrue",CTF_vehicleOnlyRespawnDamaged]
     ] ;

createParks = {
     private ["_r","_s"];
     {
	  _s = [_x] call getRegionAndModifiers ;
	  _r=[_s,carparkActions] call handleActions ;
	  carparks = carparks + [_r] ;
     } foreach (["vehicles"] call findMarkers) ; ; 
} ;


initVehicles = {
     private ["_r","_v"];
     {
	  _v = _x ;
	  //foreach vehicle check within each carpark to see whether the vehicle is present
	  {
	       _r = _x ;
	       if ([_r,position _v] call insideRegion) then {

		    {
			 // start by turfing out any crew members that are in the vehicles
			 unassignVehicle _x ;
			 _x setPos [1,1,1] ;
			 //NASTY HACK !!!!!!
			 //Place the units in an array to be deleted layer - I think 
			 //this gives the server time to flush the position to the client
			 //before deleting the unit ??
			 deadCrew = deadCrew + [_x ];
		    } foreach crew _v ;
		    
		    //Now set the vehicle up for respawn and add it to the carpark vehicle list
		    _v setVariable["startPos",getposasl _v] ;
		    _v setVariable["startDir",direction _v] ;
		    _v setVariable ["respawnDelay",_r getVariable "respawnDelay"] ;
		    _v setVariable ["onlyRespawnDamaged",_r getVariable "onlyRespawnDamaged"] ;
		    
                    //We keep a local list of vehicles to avoid having to run through all the signs and markers
		    //that are otherwise included in the 'vehicles' list
		    respawnVehicleList = respawnVehicleList + [_v] ;
	       } ;
	  }  foreach carparks ;
     } foreach  vehicles ;
};




reapCrew ={
     sleep 5 ;
     {
	  deleteVehicle _x;
     } foreach deadCrew ;
} ;


doRespawn = {
     private ["_v","_cl","_p","_d","_t","_del","_i","_resd","_crewdead"] ;
     _v = ARG0 ;
     _t = ARG1 ;
     _del = ARG2 ;
     _crewdead = true ;
     {if (alive _x) then {_crewdead = false;}; } foreach crew _v ;
     if (_crewdead ) then {
	  if (time - _t > _del) then {
	       _p = _v getVariable "startPos" ;
	       //only respawn if the vehicle has been moved away or is damaged
	       if (
		    ((damage _v) > 0.1) or  
		    ((_p distance (getposasl _v) > 20) and (not (_v getVariable "onlyrespawndamaged")))
		    )then { 

		    _cl = typeOf _v ;
		    _d = _v getVariable "startDir" ;
		    _resd = _v getVariable "onlyRespawnDamaged" ;
		    deleteVehicle _v ;
		    //replace the old array entry with the new one
		    _i = respawnVehicleList find _v ;
		    _v = _cl createVehicle [1,1,1] ;
		    respawnVehicleList set [_i,_v] ;
		    _v setposasl _p ;
		    _v setDir _d ;
		    _v setVariable["startPos",_p] ;
		    _v setVariable["startDir",_d] ;
		    _v setVariable["respawnDelay",_del] ;
		    _v setVariable["onlyRespawnDamaged",_resd] ;
		    _t = time ;
	       };
	  } ;			 
	  
     } else {
	  _t = time ;
     } ;
     [_t,_v] ;
};



doRepair={
     private ["_v","_t","_incr"];
     _v = ARG0 ;
     _t = ARG1 ; 
     {
	  //we can't repair truly wrecked vehicles
	  if ( ([_x,position _v] call insideRegion) and 
	       (damage _v < 0.8)) then {

	       if (
		    ((_v isKindof "Car") and not (_x getVariable "dontRepairCars")) or
		    ((_v isKindof "Tank") and not (_x getVariable "dontRepairTanks")) or
		    ((_v isKindof "MotorCycle") and not (_x getVariable "dontRepairBikes")) or
		    ((_v isKindof "Helicopter") and not (_x getVariable "dontRepairHelicopters")) or
		    ((_v isKindof "Plane") and not (_x getVariable "dontRepairPlanes")) 
		    ) then { 
		    
		    _incr = _t/(_x getVariable "repairTime");
		    _v setFuel ([(fuel _v) + _incr] call clamp1) ;
		    _v setdamage ([(damage _v) - _incr] call clamp0)  ;
		    //there's no way to get ammor and armour for a vehicle
		    if ((fuel _v >=0.95) and (damage _v <0.05)) then {
			 _v setVehicleAmmo 1  ;
			 _v setVehicleArmor 1  ;
		    } ;
	       } ;
	  };
	  sleep 0.001 ;
     }  foreach carparks ;
} ;

vehicleMonitor ={
     private ["_v","_del","_ret","_loop","_abandonedTime"];
     _v = ARG0 ;
     _del = _v getVariable "respawnDelay" ;
     _abandonedTime=0;
     _loop = 1 ;
     
     while {not gameOver} do {
	  if (speed _v ==0) then {[_v,_loop] call doRepair ;} ;
	    _ret =[_v,_abandonedTime,_del] call doRespawn ;
	  _abandonedTime=EL(_ret,0) ;
	  _v = EL(_ret,1) ;
	  sleep _loop ;
     };
} ;

call createParks ;
call initVehicles ;

[] spawn { [] call reapCrew ;};
{[_x] spawn { _this call vehicleMonitor ;}} foreach respawnVehicleList ;
