

#include "lib\common.h"

VAR_DEFAULT(CTF_paraDropVehicle,"C130J");
VAR_DEFAULT(CTF_waveTiming,10);
VAR_DEFAULT(CTF_paraDropHeight,200);

if (isServer) then {
     
     dropZoneActions = [
	  ["side","setString","any"]
	  ] ;
    

     createParaDropExclusions ={
	  
	  private ["_r","_m","_sp","_s","_al","_dropzones"];
	  _dropzones=[] ;
	  {
	       _m=_x ;
	       _s = [_m,false] call getRegionAndModifiers ;
	       _r=[_s,dropZoneActions,false] call handleActions;
	       _sp = format ["%1",playerSide] ;
	       _al = _r getVariable _sp ;
		    _dropzones = _dropzones+[_r] ;
	       
	  } foreach (["dropZone"] call findMarkers) ; ;
	  PUBLISH(dropZoneList,_dropzones) ;
     } ;

     paraDropActions = [
	  ["automap","setTrue",false],
	  ["vehicle","setString",CTF_paraDropVehicle],
	  ["halo","setTrue",false],
	  ["anywhere","setTrue",false],
	  ["random","setTrue",false],
	  ["objectives","setString","friendly"],
	  ["dropzones","setString","friendly"],
	  ["waveTiming","setNum",CTF_waveTiming],
	  ["height","setNum",CTF_paraDropHeight]
	  ] ;

     

     createParaDrops ={
	  
	  private ["_r","_v","_m","_s","_paraDrops"];
	  _paraDrops=[] ;
	  {
	       _m=_x ;
	       if (markerShape _m == "ICON") then {
		    _m setMarkerShape "ELLIPSE" ;
		    _m setMarkerSize [20,20] ;
	       };
	       _s = [_m,false] call getRegionAndModifiers ;
	       _r = [_s,paraDropActions] call handleActions ;
	       
	       _v =(_r getVariable "vehicle") createVehicle VAR(_r,center) ;
	       _v setFuel 0;
	       _v lock true;
	       _v setDir markerDir _x;
	       _v allowDamage false ;
	       _paraDrops = _paraDrops+[_r] ;
	       
	  } foreach (["paraDrop"] call findMarkers) ; ;
	  PUBLISH(paraDropList,_paraDrops) ;
     } ;
     
     [] call createParaDrops ;
     [] call createParaDropExclusions ; 
     
     
} ;

if (not isNull player) then { 

     activeParaDrop = objNull ;

     notInExclusionZone ={
	  private ["_pos","_r"] ;
	  _pos = ARG0 ;
	  _r = true ;
	  {
	       if ([_x,_pos] call insideRegion) exitwith {_r=false;} ;
	  }  foreach ARG1 ;
	  _r ;
     } ;
     
     validDropZone = {
	  //Options are 
	  //Any - any ojective in any state
	  //Neutral - any objective that is neutral or owned by side
	  //friendly - any objective owned by player side
	  //None - can't paradrop to objectives
	  private ["_pos","_ret","_valid"] ;
	  _pos = ARG0 ;
	  _ret = false ;
	  _valid =false ;
	  {
	       if ([_x,_pos] call insideRegion) then {
		    _valid=true ;
		    switch VAR(activeParadrop,dropZones) do {
		    case "none" : {_ret =false;} ; //add nothing
		    case "any" : {_ret=true;} ; //add all
		    case "friendly" : {
			 if (VAR(_x,side) == "any") then {_ret = true ; } else 
			 { _ret =  [VAR(_x,side),playerSide] call sidesEqual ;} ;
		    };
		    };
	       } ;
	  } foreach VAR(JIPOBJECT,dropZoneList) ;
	  [_valid,_ret] ;
     } ;

     validObjective = {
	  //Options are 
	  //Any - any ojective in any state
	  //Neutral - any objective that is neutral or owned by side
	  //friendly - any objective owned by player side
	  //None - can't paradrop to objectives
	  private ["_pos","_ret","_valid"] ;
	  _pos = ARG0 ;
	  _ret = false ;
	  _valid =false ;
	  {
	       if ([_x,_pos] call insideRegion) then {
		    _valid=true ;
		    switch VAR(activeParadrop,objectives) do {
		    case "none" : {_ret =false;} ; //add nothing
		    case "any" : {_ret=true;} ; //add all
		    case "neutral" : {
			 _ret =  not ([_x,playerSide] call objectiveHostileFor);
		    };
		    case "friendly" : {
			 _ret =  [_x,playerSide] call objectiveFriendlyFor ;
		    };
		    };
	       } ;
	  } foreach VAR(JIPOBJECT,ObjectiveList) ;
	  [_valid,_ret] ;
     } ;

     getValidObjectivesList={
	  private ["_ret"] ;
	  _ret = [] ;
	  {
	       //URGH - very inefficient - split out loop.
	       if (EL([ VAR(_x,center)] call validObjective,1)) then {
		    _ret = _ret + [_x] ;
	       } ;
	  } foreach VAR(JIPOBJECT,ObjectiveList) ;
	  _ret ;
     } ;

     getValidDropzonesList={
	  private ["_ret"] ;
	  _ret = [] ;
	  {
	       //URGH - very inefficient - split out loop.
	       if (EL([ VAR(_x,center)] call validDropZone,1)) then {
		    _ret = _ret + [_x] ;
	       } ;
	  } foreach VAR(JIPOBJECT,dropZoneList) ;
	  _ret ;
     } ;

     chooseRandomPosition={
	   private ["_r","_p","_o"];
	  _o = (call getValidObjectivesList) + (call getValidDropzonesList) ;
	  _r = EL(_o,random count _o) ;
	  _p = [_r] call randPosInsideRegion;
	  _p ;
	  
     } ;

     markPos={
	  activePos=ARG0 ;
	  if (getMarkerType "Dropmarker" =="") then {
	       createMarkerLocal ["Dropmarker",activePos] ; 
	       "Dropmarker" setmarkerShapeLocal "ICON" ;
	       "Dropmarker" setmarkerTypeLocal "Select" ;
	  } else {
	       "DropMarker" setmarkerPosLocal activePos ;
	  } ;
	  "DropMarker" setmarkerTextLocal "" ;
     } ;
     
     validDropPos ={
	  private ["_pos","_ret","_t","_valid"] ;
	  _pos = ARG0 ;
	  _pos set[2,0] ;
	  _t = true ;
	  _valid = false ;

	  if ([_pos] call posInEnemySpawn) then {
	       _t=false;
	       _valid = true ;
	  } ;
	  
	  if ([_pos] call posOutsideBorder) then {
	       _t=false;
	       _valid = true ;
	  } ;

	  if ([_pos] call posInMinefield) then {
	       _t=false;
	       _valid = true ;
	  } ;

	  _ret = [_pos] call validDropZone ;
	  if (EL(_ret,0)) then {
	       _t = _t and EL(_ret,1) ;
	       _valid = true ;
	  }  ;
	  _ret = [_pos] call validObjective ;
	  if (EL(_ret,0)) then {
	       _t = _t and EL(_ret,1) ;
	       _valid = true ;
	  }  ;
	  if (not _valid) then {
	       _t = _t and VAR(activeParadrop,anywhere) ;
	  } ;
	  if (_t) then {
	       "Dropmarker" setmarkerTextLocal "Respawn" ;
	  } else {
	       "Dropmarker" setmarkerTextLocal "Can't respawn here" ;
	  } ;
	  _t ;
     } ;

     doDrop={
	  private ["_r","_pos","_chute"] ;
	  _r = activeParadrop ;
	  _pos = ARG0 ;
	  _pos set [2,0] ;
	  _pos set [2,VAR(_r,height)] ;
	  player setpos _pos ;
	  if (EL(_pos,2) >0) then {
	       
	       if (VAR(_r,halo)) then {
		    [player,VAR(_r,height)] exec "ca\air2\halo\data\Scripts\HALO_init.sqs" ;
		    call hudShow ; //work around titleCut
		    waitUntil {EL(getpos player,2) < 1} ;
		    sleep 3 ;
		    call hudShow ; //work around titleCut
	       } else {
		    _chute = "parachute" createvehicle _pos;
		    _chute setpos _pos;
		    player assignasdriver _chute;
		    player moveindriver _chute;
		    [_chute,player]  call compile preprocessfile  "ca\air2\halo\data\Scripts\Parachute.sqf"  ;
		    call hudShow ; //work around titleCut
	       } ;
	       

	  } ;
     } ;
     
      playerAtParadrop={
	   private ["_ret","_paradrops"] ;
	   _paradrops = ARG0 ;
	   _ret=false ;
	   {
		if ([_x,position player] call insideRegion) then {
		     _ret = true ;
		     activeParadrop= _x ;
		} ;
	   } foreach _paradrops ;
	   _ret ;
      } ;

      lastDisplay=0 ;
      displayNextWave = { 
	   private ["_nextWave","_t","_respawnNow"] ;
	   _respawnNow= false ;
	   _t = gameTimeLeft ;
	   //hack to make sure that respawn waves can be tested before game starts
	   if (_t ==0) then {_t = 100000 -time ; } ;
	   if (VAR(activeParadrop,waveTiming) !=0) then {
		_nextWave = floor (_t % VAR(activeParadrop,waveTiming)) ;
		if (_nextWave != lastDisplay) then {
		     hintsilent format["%1 seconds until the next respawn wave.\nClick on the map to parachute in.",_nextWave] ;
		     lastDisplay=_nextWave ;
		} ;
		if (_nextWave ==0) then {_respawnNow=true;} ;
	   } else {
		if (time - lastDisplay >1) then {
		     hintsilent format["Click on the map to parachute in.",_nextWave] ;
		     lastDisplay=time ;
		} ;
		_respawnNow = true ;
	   } ;
	   _respawnNow ;
      } ;
      
      monitorParaDrops = {
	   private ["_pos","_state","_lastState","_doRespawn","_paradropExcludes","_paradrops","_delay"];
	   _paradrops = RECEIVE(paraDropList) ;
	   _paradropExcludes = RECEIVE(dropZoneList) ;
	   _state="respawning" ;
	   _delay = 1;
	   waitUntil {gameStarted} ;
	   while {(not gameOver) and (not playerInterned)} do {

		_lastState = _state ;
		switch (_state) do {
		case "respawning" : { 
		     if (not respawning) then {
			  _state="inplay" ;
		     } ;
		} ;
		case "inplay" : {
		     if ([_paradrops] call playerAtParadrop) then {
			  _state= "atParadrop" ;
		     };
		};
		case "atParadrop" : { 
		     call displayNextWave ;
		     if (VAR(activeParadrop,autoMap)) then {
			  openmap true;
		     } ;
		     if (visiblemap) then {
			  _delay = 0.01 ;
			  activePos = position player ;
			  _state = "inMapNoTarget" ;
			  onMapSingleClick "[_pos] call markPos" ;
		     } ;
		     if (not ([_paradrops] call playerAtParadrop)) then {
			  titleText ["","PLAIN DOWN"] ;
			  _state="inplay" ;
		     } ;
		};
		case "inMapNoTarget" : {
		     call displayNextWave ;
		     if (VAR(activeParadrop,random)) then {
			  onMapSingleClick "" ;
			  [call chooseRandomPosition] call markPos ;
			  
		     } ;
		     if ([activePos] call validDropPos) then {
			  _state="inMapValidTarget" ;
		     } ;
		     if (not visiblemap) then {
			  onMapSingleClick "" ; 
			  deleteMarkerLocal "Dropmarker" ;
			  _state = "atParadrop" ;
			  _delay = 1 ;
		     } ;
		} ;
		case "inMapValidTarget" : {
		     _doRespawn = call displayNextWave ;
		     if (not ([activePos] call validDropPos)) then {
			  _state="inMapNoTarget" ;
		     } ;
		     if (not visiblemap) then {
			  onMapSingleClick "" ; 
			  deleteMarkerLocal "Dropmarker" ;
			  _state = "atParadrop" ;
			  _delay = 1 ;
		     } ;
		     if (_doRespawn) then {
			  onMapSingleClick "" ; 
			  hint "" ;
			  deleteMarkerLocal "Dropmarker" ;
			  _state = "inplay" ;
			  openmap false ;
			  _delay = 1 ;
			  [activePos] call doDrop ;
		     } ;
		} ;
		     
		};  //switch
		if (_state == _lastState) then {sleep _delay;} ;
		
	   };//while
      } ;


      [] spawn { [] call monitorParaDrops;} ;
};
