
#include "lib\common.h" ;


/*
  Scoring system for King of the hill
  In this mode, every player is out to hold the single flag and they
  gain points by staying within the scoring area
*/ 

VAR_DEFAULT(CTF_scoreToWin,100000) ;

findWinners ={
     private ["_plrs","_winScore","_winplrs"] ;
     _plrs = call xPlayableUnits ;
     _winScore = -100000 ;
     _winplrs = [] ;
     {
	  if (score _x > _winScore) then {
	       _winScore = score _x ;
	       _winplrs = [] ;
	  } ;
	  if (score _x == _winScore) then {
	       _winplrs = _winplrs + [name _x] ;
	  };
     } foreach _plrs ;
     [_winplrs,_winScore]    
};

if (isServer) then {
     
     flagReturn={
	  //actually in KOH, this indicates that the player has wandered outside of the scoring area !
	  private ["_plr","_flg"] ;
	  _plr = ARG0 ;
	  _flg = ARG1 ;
	  [VAR(_flg,returnMsg)] call announce;
	  _plr addScore -50 ;
     } ;
     
     flagScore={
	  // can't happen in king of the hill 
     } ;
     
     flagTaken={
	  private "_plr" ;
	  _plr = ARG0 ;
	  [ format ["%1 has the flag",name _plr],"flagTaken"] call announce;
	  _plr addScore 100 ;
     } ;
     
     flagTouch={} ;
     
     flagDrop={
	  ["The flag has been dropped"] call announce ;
     };
     
     flagPickup={
	  private ["_plr"] ;
	  _plr = ARG0 ;
	  [format ["%1 has the flag",name _plr],"flagTaken"] call announce;
	  _plr addScore 100 ;
     };
     
     flagBeingTracked={
	  ["Flag-tracker enabled"] call announce ;
     } ;
     
     gameOverScore={
	  private ["_res","_str","_n"];
	  _res = [] call findWinners ; 
	  _n = count EL(_res,0) ;
	  switch (_n) do {
	  case 0 : { _str = "The game is a draw" ;} ;
	  case 1 : { _str = "The winner is...\n" ;} ;
	       default { _str = "The game is a draw" ;} ;
	  } ;
	  _str = "GAME OVER\n" + _str ;
	  {
	       _str = _str+format["%1 - %2 points\n", _x,EL(_res,1)] ;
	  } foreach (_res select 0) ;
	  
	  [_str] call announceCenter ;
     };
     
     gameOverMonitor = {
	  private ["_s"] ;
	  while {not gameOver} do {
	       _s = [] call findWinners ;
	       if ((_s select 1) >= CTF_scoreToWin) then {
		    forceGameOver=true;
	       } ; 
	       sleep 1;
	  };
     } ;
     
     [] spawn {[] call gameOverMonitor;} ;
     
     
     
//loop to add points to flag-holders score every second...
     
     KOHscoreticker = {
	  private ["_p", "_r","_sectors","_f"];
	  _sectors = [] ;
	  //Search the namespace for markers that look like scorezones 
	  _f = ["sector"] call findMarkers ;
	  {
	       _r = [_x] call createRegionFromMarker;
	       _sectors = _sectors + [_r] ;
	  } foreach _f ;
	  
	  while {not gameOver} do {
	       private ["_p"] ;
	       _p = flagOwner theFlag ;
	       if (alive _p) then {
		    {
			 if ([_x,position _p] call insideRegion) then {
			      _p addScore 1 ;
			 } 
			 else {
			      [theFlag,"The flag was taken out of the playing area"] call forceReturn ;
			 };
		    } foreach _sectors ;
	       } ;
	       
	       sleep 1 ;
	  } ;
     } ;
     
     [] spawn {[] call KOHscoreticker;} ;
} ;


if (not isNull player) then {
     hudTask={
	  private ["_res","_c","_d"];
	  waituntil {gameStarted} ;
	  
	  waitUntil {not isNil "theFlag"; };
	  [10] call hudInit ;
	  [theFlag] call createFlagHinter ;
	  while {gameState=="playing"} do {
	       _res = [] call findWinners ;
	       [0,format ["Flag: %1",[theFlag] call flagText]] call hudSetLine ;
	       [1,format ["Leaders: %1 pts",_res select 1]] call hudSetLine ;
	       _c = 0;
	       { 
		    [2+_c,format ["  %1",_x]] call hudSetLine ;
		    _c = _c +1 ;
	       } foreach (_res select 0);
	       for "_d" from _c to 7 do {
		    [2+_d,""] call hudSetLine ;
	       } ;
	       [-2,format ["YOU: %1 pts",score player]] call hudSetLine ;
	       [-1,[] call TimeLeftString] call hudSetLine ;
	       scoreHint = [] call hudStringify ;
	       sleep 1 ;
	  } ;
	  call hudHide ;
     } ;
};

