//creates a HUD to display relevant information for the game
#include "lib\common.h" ;

if (isNull player) exitwith {} ;


#define START_IDC 65000
#define NUMHUDLINES 21


linectrls=[] ;
hudIsHidden=true ;
hudStrings=[] ;
wantedLines =10 ;


hudInit={
     private ["_c"] ;
     wantedLines = ARG0 ;
     for "_c" from 0 to (NUMHUDLINES-1) do {
	  hudStrings set[_c,""];
     } ;
     call hudShow ;
} ;

hudShow ={
     private ["_hud","_c"];
     //show it again in case some other UI has displaced it
     disableSerialization ;
     cutRsc ["ScoreRsc","PLAIN"] ;

     _hud = uiNamespace getVariable "HUD";
     
     for "_c" from 0 to (wantedLines-1) do {
	   linectrls set [_c,_hud displayCtrl (START_IDC+_c + (NUMHUDLINES-wantedLines))] ;
     } ;
     hudIsHidden=false ;
} ;

hudHide ={
     hudIsHidden=true;
     {
	  _x ctrlSetText "" ;
     }
     foreach linectrls ;
} ;

hudToggle={
     if (hudIsHidden) then {call hudShow;} 
     else {call hudHide;} ;
} ;


hudSetLine = {
     private ["_n","_s"] ;
     _n = ARG0 ;
     _s = ARG1 ;
     if (_n<0) then {_n=(count linectrls)+_n;};
     hudStrings set [_n,_s] ;
     if (hudIsHidden) then {_s = "";};
     if (_n <=( count linectrls) -1) then {
	  (linectrls select _n) ctrlSetText _s ;
     } ;
} ;

hudStringify ={
     private ["_s"] ;
     _s = "" ;
     {
	  _s = format ["%1\n%2",_s ,_x] ; ;
     } foreach hudStrings ;
     _s ;
} ;

hudSetLineColour = {
     private ["_c"] ;
     _c =[1,1,1,1] ;
     switch (ARG1) do {
     case "ColorRed" : {_c = [1,0,0,1] ;};
     case "ColorGreen" : {_c = [0,1,0,1] ;};
     case "ColorBlue" : {_c = [0,0,1,1] ;};
     case "ColorWhite" : {_c = [1,1,1,1] ;};
     };

     (linectrls select ARG0) ctrlSetTextColor  _c ; ;
} ;
