#include "lib\common.h"


VAR_DEFAULT(CTF_ticketLimit,100000);
VAR_DEFAULT(CTF_ticketLimitEast,CTF_ticketLimit);
VAR_DEFAULT(CTF_ticketLimitWest,CTF_ticketLimit);
VAR_DEFAULT(CTF_deathPenalty,0);

totalTickets_east = CTF_ticketLimitEast ;
totalTickets_west = CTF_ticketLimitWest ;

knownRespawns=[] ;

penalizeForDeath={
     private ["_plr"] ;
     _plr = ARG0 ;
     if (CTF_deathPenalty > 1000) then {
	  _plr addScore -(score _plr) ;
     } else {
	  _plr addScore (- CTF_deathPenalty) ;
     } ;
} ;

ticketsUsed={
     private ["_r"];
     switch (ARG0) do {
	  case east : {_r = CTF_ticketLimitEast-totalTickets_east ; };
	  case west : {_r = CTF_ticketLimitWest-totalTickets_west ; };
     } ;
     _r ;
} ;

if (isServer) then {
     
     ticketMonitor={
	  private ["_n","_lastKnownNum","_thisNum","_lastknownNum","_diff","_side","_varname","_needUpdate"];
	  while {not gameOver} do {
	       _needUpdate=false ;
	       {
		    _side = [_x] call plrSide ; 
		    _varname = ["TICKETS",_x] call serverGetVarName ;
		    _n = knownRespawns find _varname ;
		    //make sure we have an entry in the list
		    if (_n <0) then {
			 _n = count knownRespawns ; 
			 knownRespawns = knownRespawns+ [_varname,0,false] ;
		    } ;
		    _lastknownNum = EL(knownrespawns,_n+1) ;
		    _thisNum = ["TICKETS",_x] call serverGetVar ;
		    _diff = _thisNum - _lastKnownNum ;
		    if (_diff <0) then {
			 //probably a sign that someone has quit
			 //and rejoined so broadcast it back to them
			 //TODO - should we add one here ?
			 ["TICKETS",_x,_lastKnownNum+1] call serverSendVar ;
		    } ;
		    if (_diff > 0) then {
			 //This is an opportunity to penalize players who die
			 [_x] call penalizeForDeath ;
			 //update our idea of where they are
			 knownRespawns set [_n+1,_thisNum] ;
			 if (_side ==east) then {
			      totalTickets_east=totalTickets_east -_diff ;
			      knownRespawns set [_n+2,(totalTickets_east>=0)] ;
			      
			 } ;
			 if (_side ==west) then {
			      totalTickets_west=totalTickets_west -_diff ;
			      knownRespawns set [_n+2,(totalTickets_west>=0)] ;
			 } ;
			 _needUpdate =true ;
		    } ;
	       } foreach call xPlayableUnits ; 
	       //update ticket counts iFF we detected some change
	       if (_needUpdate) then {
		    publicVariable "totalTickets_east" ;
		    publicVariable "totalTickets_west" ;
		    //Provide an ack 
		    publicVariable "knownRespawns" ;
	       };
	       sleep 1 ;
	  };
     } ;
     [] spawn {[] call ticketMonitor} ;
};

if (not isNull player) then {
     
     myTickets=0;
     
     takeTicket={
	  myTickets = myTickets+1 ;
	  ["TICKETS",myTickets] call clientSendVar ;
     } ;
     
     //synchronous version of takeTicket - means that totalTickets will be
     //updated before we return
     takeTicketSync={
	  private ["_acked","_n","_var","_ackNum","_ticketObtained"] ;
	  _var = ["TICKETS"] call clientGetVarName ;
	  call takeTicket ; 
	  _acked = false ;
	  while {not _acked} do {
	       _n = knownRespawns find _var ;
	       if (_n >=0) then {
		    _ackNum = EL(knownrespawns,_n+1) ;
		    if (_ackNum >= myTickets) then {
			 _ticketObtained=EL(knownRespawns,_n+2) ;
			 _acked = true ; 
		    } ;
	       } ;
	       sleep 0.1 ;
	  } ;
	  _ticketObtained ;
     } ;
     
     //just used for testing since it's a pain to have to respawn to test this
     ticketTaker ={
	  while {not gameOver} do {
	       sleep 5 ;
	       call takeTicketSync ;
	  } ;
     } ;
     // [] spawn {[] call ticketTaker;} ;
} ; 
