#include "lib\common.h" ;
//libraries to deal with positional uncertainty
//Uncertainty is defined in terms of meters
//when narrowing uncertainty we need to know the previous uncertainty
//because we have to stay within that

narrowUncertainty={
     private ["_p","_done","_i","_mindist","_previousUncertainty","_truePos","_newUncertainty","_v","_truepos","_previousCenter","_minDist"];
     _truepos = ARG0 ;
     _previousCenter = ARG1;
     _previousUncertainty = ARG2 ;
     _newUncertainty = ARG3 ;
     _done = false ;
     
     //0 uncertainty is a special case - just return the true position
     if (_newUncertainty ==0) then {
	  _p = _truepos ;
     } else {
	  
	  //The new area of uncertainty must lie inside the old one !
	  _mindist = (_truepos distance _previousCenter) - (2 * _newUncertainty) ;
	  if (_mindist <0) then {_mindist=0;} ;
	  _i = 0 ;
	  while {(not _done) and (_i < 5) } do {
	       _p = [_previousCenter,_minDist,_previousUncertainty-_newUncertainty] call randpos;
	       if ((_p distance _truepos) < _newUncertainty) then {_done= true;} ;
	       _i =_i+1 ;
	  };
	  //if we don't converge, which can happen if the truepos is right on the edge of the uncertain area, 
	  //then the backup plan is just to choose a point between truepos and oldcenter
	  if (not _done) then {
	       _v = [_previousCenter,_truePos] call subtractPos ;
	       _v = [_v,_newUncertainty/_previousUncertainty *0.9] call scale ;
	       _p = [_truePos,_v] call addPos ;
	  } ;
     };
     _p ;

} ;


//Assumes we already have a marker covering the uncertain area and that 
//marker reflects the current uncertainty
//Obviously we need to pass in the true position, marker name, and new uncertainty

narrowUncertainMarker={
     private ["_p","_u","_s","_m","_t"];
     _t = ARG0 ;
     _m = ARG1 ;
     _u = ARG2 ;
     _s = markerSize _m ;
     _p = [_t,markerPos _m,EL(markerSize _m,0),_u] call narrowUncertainty ;
     _m setMarkerPos _p ;
     _m setMarkerSize [_u,_u];
} ;

initUncertainMarker={
     private ["_m","_u"] ;
     _m = ARG0 ;
     _u = ARG1 ;
     _m setMarkerSize [_u*2,_u*2] ;
     [markerPos _m,_m,_u] call narrowUncertainMarker ;
} ;


