
/*
  Rearming scripts
*/

#include "lib\common.h" ;



//magazines, primary weapon, secondary weapon, items 
if (isNull player) exitwith {} ;

illegalKill =false ;
playerLoadout = [[],"",[]] ;
VAR_DEFAULT(CTF_deathCam,"body") ;
     
VAR_DEFAULT(CTF_preserveLoadout,true);
VAR_DEFAULT(CTF_preserveLoadoutOnDeath,false);
VAR_DEFAULT(CTF_allowGPS,false);
VAR_DEFAULT(CTF_allowNVG,false);
VAR_DEFAULT(CTF_allowBINO,false);
VAR_DEFAULT(CTF_respawnDelay,15);
VAR_DEFAULT(CTF_preservePlayerSpawnPos,true);
VAR_DEFAULT(CTF_playerRespawnLimit,100000) ;
VAR_DEFAULT(CTF_preventSuicide,false) ;

playerDirection = direction player ; 
playerPosition = getposasl player ; 

rearm = {
     private ["_mags"];
     removeAllItems player ;
     removeAllWeapons player ;
     _mags = playerLoadout select 0 ;
     {
	  player addMagazine _x ;
     } foreach _mags ;
     //add  weapons
     { player AddWeapon _x }  foreach (playerLoadout select 2);
     //first try selecting the secondary weapon
     if (playerLoadout select 3 != "") then {
	  player SelectWeapon (playerLoadout select 3);
     };
     //then override it by the primary weapon if appropriate
     if (playerLoadout select 1 != "") then {
	  player SelectWeapon (playerLoadout select 1);
     } ;
     //if no primary and no secondary (as in the case for pistols) then arma will just select 
     //the appropriate weapon
     if (CTF_allowGPS) then {player addWeapon "ItemGPS";} else
     {player removeWeapon "ItemGPS";} ;
     if (CTF_allowNVG) then {player addWeapon "NVGoggles";} else
     {player removeWeapon "NVGoggles";} ;
     if (CTF_allowBINO) then {player addWeapon "Binocular";} else
     {player removeWeapon "Binocular";} ;

     showmap true ;
     player addweapon "itemmap"; 
     player addweapon "itemRadio"; 
     player addweapon "itemCompass"; 
     player addweapon "itemWatch"; 
} ;


/*
  This function is called periodically whilst we're in spawn to allow us to 
   store a default loadout.
*/

updatePlayerLoadout=
{
     if (CTF_preserveLoadout) then {
	  playerLoadout set [0,magazines player] ;
	  playerLoadout set [1,primaryWeapon player] ;
	  playerLoadout set [2,weapons player] ;
	  playerLoadout set [3,secondaryWeapon player] ;
     } ;
} ;

//used at end of game to force control back to the outro sequence
cancelRespawn = false ;
respawning = false ;

cancelPendingRespawn =
{
     cancelRespawn = true ;
     waitUntil {not respawning} ;
} ;

cachedLoadout=[] ;

cacheLoadout ={
     cachedLoadout =[
	  getposasl player,
	  direction player,
	  magazines player,
	  primaryWeapon player,
	  weapons player,
	  flag player 
	  ];
} ;

deathCamOn={
     private ["_cam","_p"] ;
     switch (CTF_deathCam) do {
     case "away" : {
	  _p = [[-0.3,2],[0,0],playerDirection] call rot ;
	  _p = [playerPosition,_p] call addPos ;
	  _p set [2,1.5] ;
	  _cam = "camera" camCreate _p ;
	  _cam cameraEffect ["Internal","Back"] ;
	  _p = +playerPosition ;
	  _p set [2,1] ;
	  _cam camSetTarget _p ;
	  _cam camcommit 0 ;
     };
     case "body" : {
	  _cam = "camera" camCreate position player ;
	  _cam cameraEffect ["Internal","Back"] ;
	  _cam camSetTarget markerPos "centerMap" ;
	  _cam camcommit 0.1 ;
     };
     case "spectate" : {
	  call startSpectating ;
     } ;
     case "killer" : {
	  _cam = "camera" camCreate position player ;
	  _cam cameraEffect ["Internal","Back"] ;
	  _cam camSetTarget ARG0 ;
	  _cam camSetPos position ARG0 ;
	  _cam camcommit 0.1 ;
     } ;
     } ;
     _cam ;
} ;

deathCamOff={
     switch (CTF_deathCam) do {
     case "away" : {
	  player cameraEffect ["terminate","back"];
	  camDestroy ARG0 ;
     };
     case "body" : {
	  player cameraEffect ["terminate","back"];
	  camDestroy ARG0 ;
     };
     case "spectate" : {
	  call stopSpectating ;
     } ;
     case "killer" : {
	  player cameraEffect ["terminate","back"];
	  camDestroy ARG0 ;
     } ;
     } ;
} ;

rearmOnSpawn = {
     private ["_wep","_t","_cam","_p","_mags","_d","_weps","_tktObtained","_flg"];
     if (not respawning) then {
	  respawning = true ;
	  if (((ARG0 == ARG1) and CTF_preventSuicide) or illegalKill or playerInterned) then {
	       _p = EL(cachedLoadout,0) ;
	       _d = EL(cachedLoadout,1) ;
	       _mags = EL(cachedLoadout,2) ;
	       _wep = EL(cachedLoadout,3);
	       _weps = EL(cachedLoadout,4);
	       _flg = EL(cachedLoadout,5) ;
	       [_flg,objNull] call storeFlag ;
	       if (not alive player) then {hidebody player;} ;
	       waituntil {alive player} ;
	       [_flg,player] call storeFlag ; 
	       if (EL(playerHealth,0) >0.85) then {playerHealth set [0,0.85] ;} ; 
	       player setdamage EL(playerHealth,0) ;
	       player setHit ["legs",EL(playerHealth,1)]  ;
	       player setHit ["hands",EL(playerHealth,2)]  ;
	       if (illegalKill) then {
		    hint "You were killed illegally and have been resurrected" ;
	       } else {
		    hint "Suicide is not allowed in this game!" ;
	       } ;
	       player setposasl _p ;
	       player setdir _d ;
	       removeAllWeapons player ;
	       removeAllItems player ;
	       {player addMagazine _x ;} foreach _mags ;
	       {player AddWeapon _x} foreach _weps ;
	       
	       //this doesn't currently cope with AT weapons unlike
	       //the proper rearm script
	       if (_wep != "") then {
		    player SelectWeapon (_wep);
	       } ;
	       illegalKill = false ; 
	  } else {
	       //claim a ticket if we're running ticket based games...
	       if (CTF_preserveLoadoutOnDeath) then {
		    //try to rebuild loadout based on current weapon
		    [primaryWeapon player] call rebuildLoadout ;
	       } ;
	       _tktObtained=call takeTicketSync ;
	       
	       waituntil {alive player} ;
	       titleText [" ","BLACK OUT"] ;
	       titlefadeout 20 ;
	       _cam=[ARG1] call deathCamOn ;//pass in the killer for killer-cam
	       if (CTF_preservePlayerSpawnPos) then {
		    player setPosasl playerPosition ;
		    player setDir playerDirection ;
	       };
	       
	       CTF_playerRespawnLimit=CTF_playerRespawnLimit-1 ;
	       
	       if ((CTF_playerRespawnLimit <0) or (not _tktObtained)) then {
		    [_cam] call deathCamOff ;
		    if (markerType "internment" != "") then {
			 player setPos getMarkerPos "internment" ;
		    } ;  
		    removeAllWeapons player ;
		    titleText ["Sorry - you have used up all your respawns","PLAIN DOWN"] ;
		    playerInterned=true ;
		    //make sure that interned players drop off the scoreboard 
		    player addScore -10000 ;
		    //let the server know we are not playing any more
		    call outOfPlay ;
	       } else {
		    call rearm ;
		    _t = time ;
		    while {not cancelRespawn and ((time - _t) < CTF_respawnDelay)} do {
			 titleText [format ["%1 seconds until respawn",floor (_t+CTF_respawnDelay-time)],"Plain down",0] ;
			 sleep 1 ;
		    } ;
		    titleFadeout 0 ;
		    [_cam] call deathCamOff ;
	       } ;
	  } ;
	  if ((["DM","FF","KOH"] find CTF_gameType) >=0) then {
	       player addrating (-(rating player) -100000) ;
	  } ;
	  
	  if (CTF_useSquads) then {
	       call fetchsquad ;
	  } ;
	  respawning =false ;
     } ;
};

VAR_DEFAULT(CTF_grenades,3) ;
VAR_DEFAULT(CTF_smoke,2) ;
VAR_DEFAULT(CTF_defaultWeapon,"AK_107_pso");
VAR_DEFAULT(CTF_defaultWeaponEast,CTF_defaultWeapon);
VAR_DEFAULT(CTF_defaultWeaponWest,CTF_defaultWeapon);

//NOTE - 
//There are 12 slots to be shared between primary weapon mags and grenades/smoke grenades
//Grenade launchers have a further 8 slots for HE shells


rebuildLoadout = {
     private ["_i","_mags","_wep","_m"] ;
     _wep = ARG0 ;
     playerLoadout =[[],"",[]] ;
     player removeWeapon primaryWeapon player ;
     player addWeapon _wep  ;
     player selectWeapon _wep;
     playerLoadout set [2,weapons player] ;
     playerLoadout set [3,secondaryWeapon player] ;

     for "_i" from 1 to CTF_grenades do {
	  playerLoadout set [0,(playerLoadout select 0)+["HandGrenade"]] ; 
     } ;

     for "_i" from 1 to CTF_smoke do {
	  playerLoadout set [0,(playerLoadout select 0)+["SmokeShell"]] ; 
     };
     
     playerLoadout set [1,_wep] ;
     
     {
	  _wep = _x ;
	  if ([_wep] call isWeapon) then { 
	       _mags = [_wep] call weaponMag ;
	       _m = 12-CTF_grenades-CTF_smoke ;
	       if ([_wep] call isRocket) then {
		    _m = [_wep] call getRocketCapacity ;
	       } ;
	       
	       for "_i" from 1 to _m do {
		    playerLoadout set [0,(playerLoadout select 0)+[_mags select 0]] ; 
	       } ;
	       if (_mags select 1 != "") then { 
		    for "_i" from 1 to 8 do {
			 playerLoadout set [0,(playerLoadout select 0)+[_mags select 1]] ; 
		    } ;
	       } ;
	  } ;
     } foreach weapons player ;
};

//Create a stored loadout based either on the desired weapon, or the items that
//the player is currently carrying 
if (playerside == east) then {CTF_defaultWeapon = CTF_defaultWeaponEast;} ;
if (playerside == west) then {CTF_defaultWeapon = CTF_defaultWeaponWest;} ;

if ([CTF_defaultWeapon] call isWeapon) then {  
     removeAllItems player ;
     removeAllWeapons player ;
     [CTF_defaultWeapon] call rebuildLoadout ;
} else {
     //if the empty string is specified, just use whatever loadout
     //the player was given in the editor
     if (CTF_defaultWeapon != "none") then {
	  [] call updatePlayerLoadout ;
     } else {	  
	  removeAllItems player ;
	  removeAllWeapons player ;
     } ;
};

player addEventHandler ["KILLED",
{
     _this call cacheLoadout ;
     _this spawn {_this call rearmOnSpawn}
}
     ];

//this has to be done after the init script has completed to avoid a race with the default arming 
//it's not at all clear how to tell when it's really safe to run this - use a 5 second delay for the moment
[] spawn {sleep 5; call rearm;};


healthCheck = {
     while {not gameOver} do {
	  if (not respawning) then {
	       playerHealth=[damage player,
			     if (canstand player) then {0} else {1},
			     handsHit player] ;
	  } ;
	  sleep 1 ;
     } ;
     
     
} ;

[] spawn {call healthCheck;} ;
