
/*
  Spectating scripts
*/

#include "lib\common.h" ;

VAR_DEFAULT(CTF_spectateAll,false);

//magazines, primary weapon, secondary weapon, items 


targetPlayer= subject ;
camTypes=["Chase","Overhead","Birds-eye","Internal","Gunner","External","Group"] ;
camType="Chase";
camVec = [0,-10,3] ;
spectating=false ;
playerScroll=0;
camScroll=0;

scrollCam={
     private ["_incr","_i"];
     _incr = ARG0 ;
     _i = camTypes find camType ;
     _i = (_i + _incr + count camTypes) % (count camTypes) ;
     camType=EL(camTypes,_i) ;
     camType ;
} ;

nextCam={
     camScroll=1;
} ;
prevCam={
     camScroll=-1;
} ;

scrollPlayer={
     private ["_done","_incr","_i","_plrs","_c"];
     _incr = ARG0 ;
     _plrs = allUnits ;
     _i = _plrs find targetPlayer ;
     if (_i <0) then {_i=0;} ;
     _done=false;
     for "_c" from 1 to (count _plrs) do {
	  _i = (_i + _incr + count _plrs) % (count _plrs) ;
	  //For some reason, some maps contain logics which we would like to screen out
	  if ( ((side EL(_plrs,_i) == playerSide)  or CTF_spectateAll) 
	       and ((typeof EL(_plrs,_i)) != "Logic") 
	       )     exitwith {_done = true ;} ;
     } ;
     if (not _done) then {
	  player ;
     } else {
	  EL(_plrs,_i) ;
     } ;
} ;

prevPlayer= {
     playerScroll = -1 ;
} ;
nextPlayer= {
     playerScroll = 1 ;
} ;

retarget={
     targetPlayer= ARG0 ;
     ctrlSetText [100,name targetPlayer] ;
     [camType] call changeCam ;
     specCam camCommit 0 ;
} ;

changeCam={
     player cameraEffect ["terminate","back"] ;
     switch (ARG0) do {
     case "Chase" : {
	  specCam= externalCam ;
	  externalCam cameraEffect ["External","Back"] ;
	  camVec =[0,-10,3];
	  specCam camSetTarget targetPlayer ;
	  specCam camSetRelPos camVec ;

     } ;
     case "Overhead" : {
	  specCam= externalCam ;
	  externalCam cameraEffect ["External","Back"] ;
	  camVec =[0,-1,30];
	  specCam camSetTarget targetPlayer ;
	  specCam camSetRelPos camVec ;
     } ;
     case "Birds-eye" : {
	  specCam= externalCam ;
	  externalCam cameraEffect ["External","Back"] ;
	  camVec =[0,-1,100];
	  specCam camSetTarget targetPlayer ;
	  specCam camSetRelPos camVec ;
     } ;
     case "Gunner" : { 
	  specCam=targetPlayer ;
	  specCam switchCamera "Gunner" ;
     } ;
     case "Internal" : { 
	  specCam=targetPlayer ;
	  specCam switchCamera "Internal" ;
     } ;
     case "External" : { 
	  specCam=targetPlayer ;
	  specCam switchCamera "External" ;
     } ;
     case "Group" : { 
	  specCam=targetPlayer ;
	  specCam switchCamera "Group" ;
     } ;
	  
	  
     };
     ctrlSetText [110,ARG0] ;
     showCinemaBorder false ;
     specCam camCommit 0;

} ;



track= {
     private ["_t"];
     while {(not gameOver) and spectating} do {

	  if (playerScroll !=0 ) then {
	       _t = [playerScroll] call scrollPlayer ;
	       [_t] call retarget ;
	       playerScroll = 0 ;
	  };
	  if (camScroll !=0) then {
	       _t = [camScroll] call scrollCam ;
	       [_t] call changeCam ;
	       camScroll= 0;
	  } ;
	  
	  
	  if (isNull targetPlayer) then {
	       call nextPlayer ;
	  } else {
	       specCam camSetTarget targetPlayer ;
	       specCam camSetRelPos camVec ;
	       specCam camCommit 0.8 ;
	  };
	  
	  if (not dialog) then {
	       sleep 1 ;
	       createDialog "SpectatorDialog" ;
	       [targetPlayer] call retarget ;
     
	  } ;
	  sleep 0.03 ;
     } ;
     
} ;

spectate={
     private ["_p"];
     createDialog "SpectatorDialog" ;
     targetPlayer =player;
     _p=position targetPlayer ;
     _p set [2,10] ;
     _p set [0,EL(_p,0)+1 ] ;
     externalCam = "camera" camCreate _p ;
     externalCam camCommand "inertia on" ;
     [targetPlayer] call retarget ; 
     call track ;
     camDestroy externalCam ;
     player cameraEffect ["terminate","back"] ;
     player switchCamera "internal" ;
     closeDialog 900;
} ;

startSpectating={
     spectating=true;
     [] spawn {call spectate;} ;
} ;

stopSpectating ={
     spectating=false ;
} ;


if (isServer) then {
     
     spectatorActions = [
	  ["sideOnly","setTrue",false]
	  ] ;
     createSpectatorZones = {
	  private ["_s","_r","_specs"] ;
	  _specs = [] ;
	  {
	       _s = [_x,false] call getRegionAndModifiers ;
	       _r=[_s,spectatorActions] call handleActions;
	       _specs = _specs + [_r] ;
	  } foreach (["spectators"] call findMarkers) ;
	  PUBLISH(spectatorZones,_specs) ;
     };
     [] spawn {call createSpectatorZones} ;
};
     
if (not isNull player) then {

     waitForSpectate={
	  private ["_done","_specs"];
	  _done = false ;
	  //Check to see if we are in a spectator zone
	  _specs = RECEIVE(spectatorZones);
	  {
	       if ([_x,position player] call insideRegion) then {
	       playerInterned=true ;
	       CTF_spectateAll=true ;
	       } ;
	  } foreach _specs ;
	  //wait until the intro has finished to avoid messing up the camera selection
	  waituntil {gameStarted} ;
	  //wait until the player has been interned
	  while {not _done} do {
	       if (playerInterned)  then {
		    call startSpectating ;
		    _done = true ;
	       } ;
	       sleep 1 ;
	  } ;
     } ;
     [] spawn {call waitForSpectate;} ; 
     
};
