/*
  Scoring system for a CTF
*/ 

#include "lib\common.h" ;

VAR_DEFAULT(CTF_reverseScore,false) ;
VAR_DEFAULT(CTF_scoreToWin,100000) ;
VAR_DEFAULT(CTF_hudNoScore,false) ;
VAR_DEFAULT(CTF_hudNoObjectives,false) ;
VAR_DEFAULT(CTF_hudNoClock,false) ;

/* public variable used by both server and clients */
scoreHint="No score" ;
scoreArray=[] ;
CTF_allowDominationWin = true ;
dominationWin="" ;

if (isServer) then {
     initScore ={
     } ;
     
     flagHeld = {
	  private ["_side"];
	  _side = ARG0 ;
     } ;
     
     scoreString = {
	  "" ;
     } ;
     
     updateScoreHint ={
	  publicVariable "ObjNames" ;
     } ;
     
     updateScoreStatus ={
	  scoreArray = [0,0] + ARG2 ;
	  publicVariable "scoreArray" ;
     } ;
     
     objectiveTaken={
	  private ["_flgname","_side","_s"] ;
	  _flgname =ARG0 ;
	  _side  =ARG1;
	  if (_side == "neutral") then {_s = format ["%1 is now neutral",_flgname] ;}
	  else {
	       _s = format ["%1 belongs to the %2 side", _flgname,_side];
	  };
	  [_s,"flagTaken"] call announce;
     } ;
     
     gameOverScore={
	  private ["_r2"];
	  if (dominationWin == "") then {
	       _r2 = "You ran out of time to complete the objectives" ;
	  } else {
	       _r2 = "All objectives completed";
	  } ;
	  
	  [format ["GAME OVER\n\n%1\n",_r2] ] call announceCenter ;
	  
     };
     
     allObjectivesTaken={
	  private ["_winner"] ;
	  _winner = ARG0;
	  if (_winner == "east") then {dominationWin="East"} ;
	  if (_winner == "west") then {dominationWin="West"} ;
	  forceGameOver=true ;
     }
     
} ;

objRegions=[] ;

if (not isNull player) then {
     hudTask={
	  private ["_t","_i","_col","_pre","_lastObj","_thisObj","_hudlines","_tsk","_n","_objectiveList"];
	  waituntil {gameStarted} ;
	  _objectiveList=RECEIVE(ObjectiveList) ;
	  //remove hidden objectives
	  _t = [] ;
	  {
	       if (not VAR(_x,hidden)) then { _t = _t + [_x] ; } ;
	  } foreach _objectiveList ;
	  _objectiveList=_t ;

	  _hudlines=1 ;
	  if (not CTF_hudNoObjectives) then {
	       _hudlines = _hudlines + count _objectiveList ;
	  };
	  if (not CTF_hudNoClock) then {
	       _hudlines = 1+ _hudlines  ;
	  };
	  [_hudlines] call hudInit ;
	  //nasty hack to make sure scorearray is properly sized
	  scoreArray set[count _objectiveList+2,0] ;
	  {
	       
               //pos size dir shape
	       _n = VAR(_x,name) ;
	       _tsk =  player createSimpleTask [_n] ;
	       _tsk setSimpleTaskDescription [_n,_n,_n] ;
	       _tsk setSimpleTaskDestination VAR(_x,center) ;
	       _tsk setTaskState "CREATED" ;
	       
	  } foreach _objectiveList;
	  
	  _lastObj = "you have left the objective"  ;
	  while {gameState=="playing"} do {
	       _thisObj = "" ;
	       if (not CTF_hudNoObjectives) then {
		    _i = 0 ;
		    {
			 _pre = "  " ;
			 if ([_x,position player] call insideRegion) then {
			      _pre = "==" ;
			      _thisObj = "You are at " + VAR(_x,name) ;
			 } ;
			 _t =format ["%1%2: %3%4",_pre,VAR(_x,name),VAR(_x,owner),_pre] ; 
			 [_i,_t] call hudSetLine ;
			 _col = "" ;
			 switch (VAR(_x,owner)) do {
			 case "west" : {_col="ColorBlue"; };
			 case "east" : {_col="ColorRed"; };
			 case "neutral" : {_col="ColorWhite"; };
			 } ;
			 [_i,_col] call hudSetLineColour ;
			 _i = _i +1 ;
		    } foreach _objectiveList ;
	       } ;
	       if (not CTF_hudNoClock) then {
		    [-1,[] call TimeLeftString] call hudSetLine ;
	       } ;
	       if (_thisObj != _lastObj) then {
		    hint _thisObj ;
		    _lastObj=_thisObj ;
	       } ;
	       sleep 1 ;
	  } ;
	  call hudHide ;
     } ;
};


