
#include "lib\common.h";

VAR_DEFAULT(CTF_introMusic,"Track02_insertion") ;
VAR_DEFAULT(CTF_outroMusic,"Track19_Debriefing") ;
VAR_DEFAULT(CTF_skipIntro,false) ;
VAR_DEFAULT(CTF_introType,"FlyRound") ;
VAR_DEFAULT(CTF_introLength,30) ;
VAR_DEFAULT(CTF_outroLength,30) ;


getIntroLength = {
     private ["_r"] ;
     if (CTF_skipIntro) then {_r=5;}
     else {_r = CTF_introLength;};
     _r ;
} ; 

if (isNull player) exitwith {} ;
#include "version.h"

/*
  Camera effects...

*/




hpos = {
     private ["_p","_h"] ;
     _p = ARG0 ;
     _h = ARG1 ;
     _p set [2,_h] ;
     _p ;
} ;

rejoinPlayer={
     private ["_cam"] ;
     _cam = ARG0 ;
     _cam camSetTarget player ;
     _cam camCommit 2 ;
     waitUntil {camCommitted _cam}; 

     _cam camSetPos ([position player,2] call hpos) ;
     _cam camCommit 2 ;
     waitUntil {camCommitted _cam}; 
     
     player cameraEffect ["terminate","back"];
     camDestroy _cam ;

} ;

displayCredit ={
     private["_min"] ;
     _min = MINOR_VERSION ;
     if (_min <10) then {_min= format ["0%1",_min];} ;
     //A lot of work has gone into this set of scripts
     //so please don't remove this credit
     TitleText [format["ArmA2 PVP Script pack V%1.%2",MAJOR_VERSION,_min],"plain down"] ;
     //Thank You !
     if (TEST_VERSION!=0) then {
	  sleep 3 ;
	  TitleText [format ["TEST BUILD %1 - NOT FOR GENERAL RELEASE",TEST_VERSION],"BLACK OUT"];
	  TitleFadeout 5 ;
	  sleep 5 ; 
     } ;
} ;

/*
  Loop the camera around the map, displaying titles as we go...
*/
introSequenceFlyRound = {
     private ["_np","_start","_cam","_center","_thisTitle","_progress","_t0","_spinLength","_lastTitle"];
     _center = getMarkerPos "centerMap" ;
     _start = position player ;
     showCinemaBorder true ;
     _np = [_start,30] call hpos ;
     _cam = "camera" camCreate _np ; ;
     _cam cameraEffect ["Internal","Back"] ;
     _cam camCommand "inertia on" ;
     _cam camSetTarget _center ;
     _cam camCommit 0 ;
     titlefadeout 1 ;
     sleep 1 ;
     0 fademusic 0 ;
     5 fademusic 1 ;
     playMusic CTF_introMusic ;

     _t0 = time ;
     _lastTitle= - 1;
     //allow 2 seconds for switch to player
     _spinLength=CTF_introLength-2 ;
     while {time -_t0 < _spinLength} do {
	  _progress = (time-_t0)/_spinLength ;
	  
	  _np = [_start,_center,360*_progress] call rot ;
	  _np = [_np,30] call hpos ;
	  _cam camSetPos _np ;
	  _cam camCommit 0 ;
	  _thisTitle = floor ((count CTF_Titles) * _progress) ;
	  if (_thisTitle >= count CTF_Titles) then {
	       _thisTitle = (count CTF_Titles) -1 ;
	  } ;
	  if (_thisTitle != _lastTitle) then {
	       _lastTitle=_thisTitle ;
	       TitleText [CTF_Titles select _thisTitle,"plain"] ; 
	  } ;
	  sleep 0.0001 ;
     } ;
     call displayCredit ;
     [_cam] call rejoinPlayer ;
     player cameraEffect ["terminate","back"];
     camDestroy _cam ;
     showCinemaBorder false ;
     titleFadeout 1;
     5 fademusic 0 ;
} ;

introSequenceFlyRoute = {
     private ["_i","_np","_titleStep","_steps","_start","_cam","_center","_r","_routeStep","_routeStops"];
     _center = getMarkerPos "centerMap" ;
     _start = position player ;
     showCinemaBorder true ;
     _np = [_start,30] call hpos ;
     _cam = "camera" camCreate _np ; ;
     _cam cameraEffect ["Internal","Back"] ;
     _cam camCommand "inertia on" ;
     _cam camSetTarget _center ;
     _cam camCommit 0 ;
     titlefadeout 1 ;
     sleep 1 ;
     _steps = CTF_introLength * 5 ;
     _titleStep = ceil(_steps/(count CTF_Titles)) ; 
     _routeStops =[];
     if (getMarkerType "respawn_east" != "") then {
	  _routeStops = _routeStops + ["respawn_east"]; 
     } ;
     if (getMarkerType "respawn_west" != "") then {
	  _routeStops = _routeStops + ["respawn_west"]; 
     } ;
     if (CTF_gameType =="CTF") then {
     _routeStops =["eFlag","wFlag"] ;
     } else {
	  _routeStops =["objective"] call findMarkers ;
     };

     if (playerside  == west) then {
	  _routeStops = [_routeStops] call reverseArray ;
     } ;

     _routeStep = ceil(_steps/(count _routeStops)) ; 
     0 fademusic 0 ;
     5 fademusic 1 ;
     playMusic CTF_introMusic ;
     for "_i" from 0 to (_steps-1) do {
	  if (_i % _titleStep ==0) then {
	       TitleText [CTF_Titles select (_i/_titleStep),"plain"] ; 
	  } ;
	  if (_i % _routeStep ==0) then {
	       _r = _routeStops select (_i/_routeStep) ;
	       _np = markerPos _r ;
	       _cam camSetTarget _np ;
	       //avoid gymbal lock by using a small offset
	       _np = [_np,10,20] call randPos ;
	       _np = [_np,30] call hpos ;
	       _cam camSetPos _np ; 
	       _cam camCommit (1+CTF_introLength/(count _routeStops));
	  };

	  sleep 0.2 ;
     } ;
     call displayCredit ;
     [_cam] call rejoinPlayer ;
     showCinemaBorder false ;
     titleFadeout 1;

     5 fademusic 0 ;

} ;

introSequenceNoCam = {
     private ["_i","_titleStep","_steps"];

     titlefadeout 1 ;
     sleep 1 ;
     _steps = CTF_introLength * 20 ;
     _titleStep = ceil(_steps/(count CTF_Titles)) ; 
     0 fademusic 0 ;
     5 fademusic 1 ;
     playMusic CTF_introMusic ;
     for "_i" from 0 to (_steps-1) do {
	  if (_i % _titleStep ==0) then {
	       TitleText [CTF_Titles select (_i/_titleStep),"plain"] ; 
	  } ;
	  sleep ((CTF_introLength-2)/_steps) ;
	  
     } ;

     call displayCredit ;
     titleFadeout 3;
     sleep 2 ;
     5 fademusic 0 ;
} ;

outroSequence = {
     private ["_np","_start","_cam","_center","_t"];
     _center = getMarkerPos "centerMap" ;
     _start = position player ;
     titlefadeout 100 ;
     showCinemaBorder true ;
     _cam = "camera" camCreate position player ;
     _cam cameraEffect ["Internal","Back"] ;
     _cam camCommand "inertia on" ;

     _cam camSetTarget _center ;

     0 fademusic 0 ;
     5 fademusic 1 ;
     playMusic CTF_outroMusic ;
     //make sure the game-over text stays up 
     _np = position player ;
     _np = [_np,200] call hpos ;
     _cam camSetPos _np ;
     _cam camCommit (CTF_outroLength) ;
     _t = time ;
     while {time < (_t + CTF_outroLength-11) } do {
	  sleep 11 ;
	  call repeatLastAnnouncement ;
     } ;
     waitUntil {camCommitted _cam}; 
     //titleFadeout 5 ;
     5 fademusic 0 ;
     sleep 5 ;
     player cameraEffect ["terminate","back"];
     camDestroy _cam ;
     showCinemaBorder false ;
} ;

player cameraEffect ["terminate","back"];
camDestroy logocam ;

titleText ["","BLACK FADED"] ;
titleFadeout 3;

if (CTF_testing) then {
     titleText ["TEST MODE\n\nIntro disabled\nUse CTF_testing=false to see the Intro in single-player or hosted-server modes","PLAIN"] ;
     titleFadeout 10;
} else {
     switch (CTF_introType) do {
     case "FlyRoute" : {   call introSequenceFlyRoute ;} ;
     case "FlyRound" : {   call introSequenceFlyRound ;} ;
     case "TextAndMusic" : {   call introSequenceNoCam ;} ;
     } ;
};

disableUserInput false ;
