#include "lib\common.h"

droppedFlags =[markerPos "centermap",markerPos "centerMap"];


forceReturn ={
     SETVARP(ARG0,forceReturn,true) ;
     SETVARP(ARG0,returnMsg,ARG1) ;
} ;

//moves a flag to a specified place
//a null destination means we'll just stash it on the flagHolder
//ARG0 = flag, ARG1=dest
storeFlag={
     if (ARG0 != objNull) then {
	  if (ARG1 == objNull) then {
	       ARG0 setFlagOwner flagHolder ;
	  } else {
	       ARG0 setFlagOwner ARG1 ;
	  } ;
     } ;   
} ;


flagText={
     private ["_r"] ;
     _r = "unknown" ;
     switch (VAR(ARG0,state)) do {
	  case "onRunner": {_r = name flagOwner ARG0;} ;
	  case "onBody": {_r = "dropped";} ;
	  case "onPole": {_r = "on-pole";} ;
	  case "limbo": {_r = "returning...";} ;
     } ; 
     _r ;
} ;


/*This only runs on the server*/

if (not isServer) exitwith {} ;


checkFlags = {

     private ["_nmeFlag","_pSide","_n","_o","_p","_i"] ;
     //get args
     _nmeFlag = ARG0 ;
     _i = 0;
     
     //The owner of the flag is critical to the state machine.  Note that the owner is null when on the flagpole
     //but may be a random string when the player dies
     _o = flagOwner _nmeFlag ;
     if (VAR(_nmeFlag,side) == "east") then {_i=1;} ; 

     if (VAR(_nmeFlag,forceReturn)) then {
	  SETVARP(_nmeFlag,state,"onPole") ;
	  _nmeFlag setFlagOwner objNull ;
	  [_o,_nmeFlag] call flagReturn;
	  SETVAR(_nmeFlag,forceReturn,false);
	  _o = objNull ;
     } ;

     switch (VAR(_nmeFlag,state) ) do {
	  
     case "limbo" : {
	  if (time > VAR(_nmeFlag,limboStart) + CTF_flagRespawnDelay) then {
	       _nmeFlag setFlagOwner objNull ;
	       SETVARP(_nmeFlag,state,"onPole");
	  } ; 
     } ;

     case "onPole" : {
	  //When on the pole, the only thing that can happen is that the flag is removed
	  if (! isnull _o ) then {
	       [_o,[_o] call plrSide] call flagTaken ;
	       SETVARP(_nmeFlag,touched,false) ;
	       SETVARP(_nmeFlag,state,"onRunner") ;
	       SETVAR(_nmeFlag,timeTaken,time);
	       SETVAR(_nmeFlag,pickupTime,time);
	  } ;
     } ;
     case "onRunner" : {
	  //If a runner is carrying the flag, they might be killed or may score.
	  //If killed the 'owner' variable gets set to a randomish string (not null)
	  if (!alive _o) then {
	       //TODO - check this works !
	       [[_o] call plrSide]  call flagDrop ;
	       SETVARP(_nmeFlag,state,"onBody") ;
	       SETVAR(_nmeFlag,bodyPos,position _o) ;
	       SETVAR(_nmeFlag,dropTime,time);
	       droppedFlags set [_i,position _o] ;
	       publicVariable "droppedFlags" ;
	  } else {
	       //Check to see if we have been awarded a flagtouch
	       if (not VAR(_nmeFlag,touched) and 
		   (time-VAR(_nmeFlag,pickupTime)) > CTF_flagTouchDelay) then {
		    SETVARP(_nmeFlag,touched,true) ;
		    [_o,[_o] call plrSide] call flagTouch ;
	       } ; 
	       //Scoring can only happen if the runners own flag is on its pole
	       {
		    if ( ((_o distance _x) < 5) and 
			 (not ([_x,_o] call flagLocked))
			 )then {  
			 [_o,[_o] call plrSide,_x] call flagScore ;
			 SETVARP(_nmeFlag,state,"limbo") ;
			 SETVARP(_nmeFlag,limboStart,time) ;
			 _nmeFlag setFlagOwner flagHolder ;
		    } ;
	       } foreach VAR(_nmeFlag,scoringFlags) ;
      
	  } ;
	  //In theory we should check here to see if a flag has been returned before we've noticed the flagrunner is dead
	  //but that's a pretty unlikely race condition 
     } ;
     case "onBody" : {
	  //Check to see if the flag has been returned in which case the owner will be null
	  if (isNull _o) then {
	       //try to guess who returned it - by looking for the nearest alive player
	       _n = nearestObjects [VAR(_nmeFlag,bodyPos),["Man"],5] ;
	        _p =objNull;
	       { 
		    if (alive _x) exitwith {_p=_x }; 
	       } foreach _n ;
	       if (not isNull _p) then {
		    [_p,[_p] call plrSide] call stdFlagReturn;
	       } ;
	       SETVARP(_nmeFlag,state,"onPole") ;
	       SETVARP(_nmeFlag,nearestPlayer,objNull) ;
	       
	  } else {
	       //Otherwise it may have been picked up by someone else 
	       //In that case, reset the pickkup time for flag-touches
	       if (alive _o) then {
		    [_o,[_o] call plrSide] call flagPickup ;
		    SETVARP(_nmeFlag,state,"onRunner") ;
		    SETVARP(_nmeFlag,nearestPlayer,objNull) ;
		    SETVAR(_nmeFlag,pickupTime,time);
	       } else {
		    //if we get here, the flag is still on the body - check the 
		    //lost flag timer to see if it needs to be returned....
		    if (time - VAR(_nmeFlag,dropTime) > CTF_lostFlagTime) then {
			 SETVARP(_nmeFlag,state,"onPole") ;
			 _nmeFlag setFlagOwner objNull ;
			  SETVARP(_nmeFlag,nearestPlayer,objNull) ;
		    } else {
			 //try to workaround difficulty in picking up/returning flag
			 _n = nearestObjects [ VAR(_nmeFlag,bodyPos),["Man"],2] ;
			 _p =objNull;
			 { 
			      if (alive _x) exitwith {_p=_x }; 
			 } foreach _n ;
			 if (_p != VAR(_nmeFlag,nearestPlayer)) then { 
			      SETVARP(_nmeFlag,nearestPlayer,_p) ;
			      SETVARP(_nmeFlag,nearestPlayerTime,[10] call gameTimeFromNow) ;
			 } else {
			      if ([VAR(_nmeFlag,nearestPlayerTime)] call pastGameTime) then {
				   //either return or transfer flag...
				   _pSide = format ["%1",[VAR(_nmeFlag,nearestPlayer)] call plrSide];
				   if (VAR(_nmeFlag,side) !=  _pSide) then {
					_nmeFlag setFlagOwner VAR(_nmeFlag,nearestPlayer) ;
				   } else { 
					_nmeFlag setFlagOwner objNull  ;
				   } ;
				   SETVARP(_nmeFlag,nearestPlayer,objNull) ;
			      } ;
			 };
		    } ; //timeout
	       } ; //alive flagowner
	  }; //null flagowner 
     } ; //case
     } ; //switch
}; //function 
     


setFlagSideAndTexture={
     private ["_flg","_side","_txt"] ;
     _flg = ARG0 ;
     _side = ARG1;
     switch (_side) do {
     case east : {_txt =  "ctf\flags\east.jpg" ;} ;
     case west : {_txt =  "ctf\flags\west.jpg" ;} ;
	  default {_txt =  "ctf\flags\neutral.jpg" ;} ;
     } ;
     _flg setFlagTexture _txt ;
     _flg setFlagSide _side ;
} ;


flagActions = [
     ["score","setNum",1],
     ["flagheight","setNum",0]
     ] ;

initFlag={
     private ["_flg","_m","_side","_name","_r","_p","_s"] ;
     _m = ARG0 ;
     _side = ARG1;
     _name = "" ;
     if (count _this > 2) then { _name = ARG2 ;} ;
     _flg = "FlagCarrierRU" createVehicle markerPos _m ;
     [_flg,_side] call setFlagSideAndTexture ;

     _s = [_m,false] call getRegionAndModifiers ;
     _r=[_s,flagActions,false] call handleActions;
     
     if (VAR(_r,name) != "") then {
	  _name = VAR(_r,name) ; 
     }  ;
     SETVARP(_flg,score,VAR(_r,score)) ;
     SETVAR(_flg,flagheight,VAR(_r,flagheight)) ;

     /* Flags need to be setpos'd to make sure they end up inside buildings
	if necessary
     */

     _p = markerPos _m ;
     _p set [2,VAR(_flg,flagheight)] ;
     _flg setPos _p ;


     _flg setVariable ["side",format ["%1",_side]] ;
     SETVAR(_flg,forceReturn,false) ;
     SETVAR(_flg,rawSide,_side) ;
     SETVARP(_flg,nearestPlayer,objNull) ;
     SETVARP(_flg,nearestPlayerTime,0) ;
     _m setmarkerType "Flag1" ;
     _m setmarkerText format ["%1 Flag",_side] ;
     if (_name != "") then {
	  _m setmarkerText _name ;
     } ;
     _m setmarkerColor ([_side] call sideColour );
     [_m] call addJIPsafeMarker ;
     SETVARP(_flg,state,"onPole") ;
     _flg ;
} ;

setScoringFlags={
     SETVARP(ARG0,scoringFlags,ARG1) ;
} ;

VAR_DEFAULT(CTF_flagTrackInterval,30);
VAR_DEFAULT(CTF_flagTrackDelay,300);
VAR_DEFAULT(CTF_lostFlagTime,300);
VAR_DEFAULT(CTF_flagRespawnDelay,0);
VAR_DEFAULT(CTF_flagTouchDelay,5);

flagTracker = {
     private ["_flg","_tracker","_timeTaken"];
     _flg = ARG0;
     waitUntil {gameStarted} ;
     _tracker = "" ;
     _timeTaken=0 ;
     
     while {not gameover} do {
	  _timeTaken = VAR(_flg,timeTaken) ;
	  if ( (not (VAR(_flg,state) in ["onPole","limbo"])) and 
	       ((time - _timeTaken) > CTF_flagTrackDelay)
	       ) then {
	       if ( _tracker == "") then {
		    [] call flagBeingTracked ;
		    _tracker = [format ["%1 flag",VAR(_flg,side)],position _flg] call  JIPsafeCreateMarker ;
		    _tracker setMarkerShape "ICON" ;
		    _tracker setMarkerType "Dot" ;
		    _tracker setMarkerText _tracker ;
		    _tracker setMarkerColor "ColorOrange";
	       } ;
	       _tracker setMarkerPos position flagowner _flg ;
	  } else {
	       //clean up any old markers 
	       if (_tracker != "") then {
		    [_tracker] call JIPSafeDeleteMarker ;
	       } ;
	  } ;
	  sleep CTF_flagTrackInterval;
     } ;
} ;


flagMonitor = {
     waitUntil {gameStarted} ;
     //create a logic to store limbo'd flags
     flagHolder =  createGroup west  createUnit ["Logic",[1,1,1],[],0,"FORM"]  ;
     while {not gameOver} do {
	  {
	       [_x] call checkFlags ;
	  } foreach  _this ;
	  sleep 0.5 ;
     };
} ;




switch (CTF_gameType) do {
 case "CTF" : {call compile preprocessfile "ctf\flagCtf.sqf";} ;
 case "FF" : {call compile preprocessfile "ctf\flagFF.sqf";} ;
 case "ECL" : {call compile preprocessfile "ctf\flagECL.sqf";} ;
 case "RUGBY" : {call compile preprocessfile "ctf\flagRUGBY.sqf";} ;
 case "KOH" : {call compile preprocessfile "ctf\flagKOH.sqf";} ;
} ;


