/*
  Scoring system for a DM
*/ 

#include "lib\common.h" ;



VAR_DEFAULT(CTF_scoreToWin,100000) ;

findWinners ={
     private ["_plrs","_winScore","_winplrs"] ;
     _plrs = call xPlayableUnits ;
     _winScore = -100000 ;
     _winplrs = [] ;
     {
	  if (score _x > _winScore) then {
	       _winScore = score _x ;
	       _winplrs = [] ;
	  } ;
	  if (score _x == _winScore) then {
	       _winplrs = _winplrs + [name _x] ;
	  };
     } foreach _plrs ;
     [_winplrs,_winScore]    
};

if (isServer) then {

     gameOverScore={
	  private ["_res","_str","_n"];
	  _res = [] call findWinners ; 
	  _n = count EL(_res,0) ;
	  switch (_n) do {
	  case 0 : { _str = "The game is a draw" ;} ;
	  case 1 : { _str = "The winner is...\n" ;} ;
	       default { _str = "The game is a draw" ;} ;
	  } ;
	  _str = "GAME OVER\n" + _str ;
	  {
	       _str = _str+format["%1 - %2 points\n", _x,EL(_res,1)] ;
	  } foreach (_res select 0) ;
	  
	  [_str] call announceCenter ;
     };
     
     gameOverMonitor = {
	  private ["_s"] ;
	  while {not gameOver} do {
	       _s = [] call findWinners ;
	       if ((_s select 1) >= CTF_scoreToWin) then {
		    forceGameOver=true;
	       } ; 
	       sleep 1;
	  };
     } ;
     [] spawn {[] call gameOverMonitor;} ;
     
};


if (not isNull player) then {
     hudTask={
	  private ["_res","_c","_d"];
	  waituntil {gameStarted} ;

	  [10] call hudInit ;
	  while {gameState=="playing"} do {
	       _res = [] call findWinners ;
	       [0,format ["Leaders: %1 pts",_res select 1]] call hudSetLine ;
	       _c = 0;
	       { 
		    [1+_c,format ["  %1",_x]] call hudSetLine ;
		    _c = _c +1 ;
	       } foreach (_res select 0);
	       for "_d" from _c to 7 do {
		    [1+_d,""] call hudSetLine ;
	       } ;
	       [-2,format ["YOU: %1 pts",score player]] call hudSetLine ;
	       [-1,[] call TimeLeftString] call hudSetLine ;
	       scoreHint = [] call hudStringify ;
	       sleep 1 ;
	  } ;
	  call hudHide ;
     } ;
};
     
     

