/*
  Scoring system for a CTF
*/ 

#include "lib\common.h" ;

VAR_DEFAULT(CTF_reverseScore,false) ;
VAR_DEFAULT(CTF_scoreToWin,100000) ;

/* public variable used by both server and clients */
scoreHint="No score" ;
scoreArray=[] ;
dominationWin="" ;

if (isServer) then {
     initScore ={
	  east_points =0 ;
	  west_points =0 ;
     } ;
     
     flagHeld = {
	  private ["_side"];
	  _side = ARG0 ;
	  call compile format ["%1_points=%1_points+1",_side];
     } ;

     scoreString = {
	  if (CTF_reverseScore) then {
	       format ["%1\nEAST %2 points\nWEST %3 points\n",
		       _this select 0,
		       CTF_scoreToWin-west_points, CTF_scoreToWin-east_points] ;
	  } else {
	       format ["%1\nEAST %2 points\nWEST %3 points\n",
		       _this select 0,
		       east_points, west_points] ;
	  } ;
     } ;
     updateScoreHint ={
	  publicVariable "ObjNames" ; //FIX
     } ;

     updateScoreStatus ={
	  east_points = east_points + ARG0 ;
	  west_points = west_points + ARG1 ;
	  if (CTF_reverseScore) then {
	       scoreArray = [CTF_scoreToWin-west_points,CTF_scoreToWin-east_points] + ARG2 ;
	  } else {
	       scoreArray = [east_points,west_points] + ARG2 ;
	  } ;
	  //check to see if someone has won
	  if ((east_points >= CTF_scoreToWin) or (west_points >= CTF_scoreToWin)) then {
	       forceGameOver=true ;
	  } ;
	  publicVariable "scoreArray" ;
     } ;
     
     objectiveTaken={
	  private ["_flgname","_side","_s"] ;
	  _flgname =ARG0 ;
	  _side  =ARG1;
	  if (_side == "neutral") then {_s = format ["%1 is now neutral",_flgname] ;}
	  else {
	       _s = format ["%1 belongs to the %2 side", _flgname,_side];
	  };
	  [_s,"flagTaken"] call announce;
     } ;

     gameOverScore={
	  private ["_res","_r2"];
	  _res = "The game is a draw" ;
	  if (dominationWin == "") then {
	       if (east_points > west_points) then {  _res = "East wins !" ;} ;
	       if (west_points > east_points) then {  _res = "West wins !" ;} ;
	       _r2 = [""] call scoreString ;
	  } else {
	       _r2 = "" ;
	       _res = format["%1 won by capturing all objectives",dominationWin] ;
	  } ;
	  
	  [format ["GAME OVER\n\n%1\n\n%2",_res,_r2] ] call announceCenter ;

     };

     allObjectivesTaken={
	  private ["_winner"] ;
	  _winner = ARG0;
	  if (_winner == "east") then {dominationWin="East"} ;
	  if (_winner == "west") then {dominationWin="West"} ;
	  forceGameOver=true ;
     }

} ;

eastCaches =[] ;

broadcastExactLocations={
     private ["_o"];
     waituntil {doneObjectives} ;
     {
	  _o = _x ;
	  if ([_o] call isDestroyObjective) then {
	       {
		    eastCaches = eastCaches + [position _x] ;
	       } foreach VAR(_x,objectArray) ; 
	  } ;
     } foreach CHObjectives ;
     publicVariable "eastCaches" ;
} ;

markExactLocations={
     {
	  ["cache",_x,"Flag1"] call addLabel ;
     } foreach eastCaches ;
} ;

if (isServer) then {[]spawn{call broadcastExactLocations;};};
 

objRegions=[] ;

if (not isNull player) then {
     hudTask={
	  private ["_t","_i","_col","_pre","_lastObj","_thisObj"];
	  waituntil {gameStarted} ;
	  waituntil {not isNil "ObjNames";} ;
	  waituntil {count ObjNames>0;} ;
	  waituntil {count eastCaches>0;} ;
	  if (playerside == east) then {call markExactLocations;} ;
	  [4+ count ObjNames] call hudInit ;
	  //nasty hack to make sure scorearray is properly sized
	  scoreArray set[count ObjNames+2,0] ;
	  {
	       //pos size dir shape
	       //FIX
		    objregions=objRegions+ [[EL(_x,1),EL(_x,2),EL(_x,3),EL(_x,4)] call createRegion];
	  } foreach objNames;
	  
	  _lastObj = "you have left the objective"  ;
	  while {gameState=="playing"} do {
	       _thisObj = "" ;
	       for "_i" from 0 to (count ObjNames -1) do {
		    _pre = "  " ;
		    if ([EL(objRegions,_i),position player] call insideRegion) then {
			 _pre = "==" ;
			 _thisObj = "You are at " + EL(EL(objNames,_i),0) ;
		    } ;
		    _t =format ["%1%2: %3%4",_pre,EL(EL(ObjNames,_i),0),EL(scoreArray,_i+2),_pre] ; 
		    [_i,_t] call hudSetLine ;
		    _col = "" ;
		    switch (EL(scoreArray,_i+2)) do {
		    case "west" : {_col="ColorBlue"; };
		    case "east" : {_col="ColorRed"; };
		    case "neutral" : {_col="ColorWhite"; };
		    } ;
		    [_i,_col] call hudSetLineColour ;
	       } ;
	       [-3,format ["East: %1",EL(scoreArray,0)] ] call hudSetLine ;
	       [-2,format ["West: %1",EL(scoreArray,1)] ] call hudSetLine ;
	       [-1,format ["Tickets %1",totalTickets_west]] call hudSetLine ;
	       scoreHint = [] call hudStringify ;
	       if (_thisObj != _lastObj) then {
		    hint _thisObj ;
		    _lastObj=_thisObj ;
	       } ;
	       if (totalTickets_west <=0) then {["east"] call allObjectivesTaken;} ;
	       sleep 1 ;
	  } ;
	  call hudHide ;
     } ;
};
     
     
