
#include "lib\common.h" ;

/*
  Scoring system for a team DM
*/ 
VAR_DEFAULT(CTF_scoreToWin,100000) ;


if (isServer) then {

     getTeamScores={
	  [[west] call ticketsUsed,[east] call ticketsUsed] ;
     } ;

     gameOverScore={
	  private ["_e","_w","_res"] ;
	  _res = [] call getTeamScores ;
	  _e = _res select 0 ;
	  _w = _res select 1 ;
	  if (_e > _w) then {
	       [format["GAME OVER\nEast %1 West %2\nEast win!",_e,_w]] call announceCenter ;
	  } ;
	  if (_e < _w) then {
	       [format["GAME OVER\nEast %1 West %2\nWest win!",_e,_w]] call announceCenter ;
	  } ;
	  if (_e == _w) then {
	       [format["GAME OVER\nEast %1 West %2\nDRAW!",_e,_w]] call announceCenter ;
	  } ;
     } ;
     gameOverMonitor = {
	  while {not gameOver} do {
	       teamScores = [] call getTeamScores ;
	       publicVariable "teamScores" ;
	       if (((teamScores select 0) >= CTF_scoreToWin) or
		   ((teamScores select 1) >= CTF_scoreToWin) 
		    )  then {
		    forceGameOver=true;
	       } ; 
	       sleep 1;
	  };
     } ;
     [] spawn {[] call gameOverMonitor;} ;

} ;



if (not isNull player) then {
     hudTask={
	  waituntil {gameStarted} ;
	  [4] call hudInit ;
	  while {gameState=="playing"} do {
	       [0,format ["East: %1",teamScores select 0]] call hudSetLine ;
	       [1,format ["West: %1",teamScores select 1]] call hudSetLine ;
	       [-1,[] call TimeLeftString] call hudSetLine ;
	       scoreHint = [] call hudStringify ;
	       sleep 1 ;
	  } ;
	  call hudHide ;
     } ;
};
     
