
#include "common.h" ;

// functions to do with probability and exponentiation


//ARG0 is the halflife value.  
//Values of ARG1 greater than this make it
//exponentially more likely for the function to return FALSE
//Values of ARG1 less than the halflife make it likely that the
//function will return TRUE

halfLifeExpired ={
     private ["_p"] ;
     _p = exp (ARG1 * (ln 0.5) / ARG0 ) ;
     ( _p < random 1) ;
} ;

// return a value based on the halflife (ARG0) and
// random value from 0..1 (ARG1)
expRand={
     private ["_p"] ;
     _p = random 1 ;
     if (_p< 0.0000001) then {_p=0.0000001;} ;
     ARG0 * (ln ARG1) /( ln 0.5) ;
} ;


//ARG0 = distance to full
//ARG1 = d
//ARG2 = start
linearInterpolation={
     private ["_i"] ;
     _i = ARG1/ARG0 + ARG2;
     if (_i>1) then {_i=1;} ;
     _i ;
} ;

clamp1={
     private ["_i"] ;
     _i = ARG0 ;
     if (_i>1) then {_i = 1;} ;
     _i ;
} ;
clamp0={
     private ["_i"] ;
     _i = ARG0 ;
     if (_i <0) then {_i =0;} ;
     _i ;
};


getInterval={
     private ["_a","_i"] ;
     _a = toArray (tolower ARG0) ;
     _i = 1 ;
     switch (toString [EL(_a,0)]) do {
	 case "r" : {
	  _a = _a -[EL(_a,0)] ;
	  _i = random (parseNumber (toString _a)) ;
	} ;
	  case "h" : {
	  _a = _a -[EL(_a,0)] ;
	  _i =  parseNumber (toString _a) ;
	  _i = [_i,random 1] call expRand;
	  } ;
     default  {

	  _i = parseNumber (toString _a) ;
     } ;
     };
     _i ;
} ;

     
