
#include "lib\common.h" ;


/*
  Scoring system for a flag-fight
*/ 

VAR_DEFAULT(CTF_scoreToWin,100000) ;

findWinners ={
     private ["_plrs","_winScore","_winplrs"] ;
     _plrs = call xPlayableUnits ;
     _winScore = -100000 ;
     _winplrs = [] ;
     {
	  if (score _x > _winScore) then {
	       _winScore = score _x ;
	       _winplrs = [] ;
	  } ;
	  if (score _x == _winScore) then {
	       _winplrs = _winplrs + [name _x] ;
	  };
     } foreach _plrs ;
     [_winplrs,_winScore]    
};

if (isServer) then  {

     flagScore={
	  private ["_plr"] ;
	  _plr = ARG0 ;
	  [ format ["%1 scored a flag",name _plr],"flagScored"] call announce;
	  _plr addScore 10 ;
     } ;
     
     flagTouch={
	  private "_plr" ;
	  _plr = ARG0 ;
	  [ format ["%1 took the flag",name _plr],"flagTaken"] call announce;
	  _plr addScore 2 ;
     } ;
     
     flagDrop={
	  ["The flag has been dropped"] call announce ;
     };
     
     flagReturn={
	  //flag has been returned = possibly through going into a noflag zone
	  private ["_plr","_flg"] ;
	  _plr = ARG0 ;
	  _flg = ARG1 ;
	  [VAR(_flg,returnMsg)] call announce;
     } ;
 

     flagPickup={
	  private ["_plr"] ;
	  _plr = ARG0 ;
	  [format ["%1 has picked up the flag",name _plr]] call announce;
     };

     flagBeingTracked={
	  ["Flag-tracker enabled"] call announce ;
     } ;
    
     gameOverScore={
	  private ["_res","_str","_n"];
	  _res = [] call findWinners ; 
	  _n = count EL(_res,0) ;
	  switch (_n) do {
	  case 0 : { _str = "The game is a draw" ;} ;
	  case 1 : { _str = "The winner is...\n" ;} ;
	       default { _str = "The game is a draw" ;} ;
	  } ;
	  _str = "GAME OVER\n" + _str ;
	  {
	       _str = _str+format["%1 - %2 points\n", _x,EL(_res,1)] ;
	  } foreach (_res select 0) ;
	  
	  [_str] call announceCenter ;
     };
     
     gameOverMonitor = {
	  private ["_s"] ;
	  while {not gameOver} do {
	       _s = [] call findWinners ;
	       if ((_s select 1) >= CTF_scoreToWin) then {
		    forceGameOver=true;
	       } ; 
	       sleep 1;
	  };
     } ;
     [] spawn {[] call gameOverMonitor;} ;
     
     
};


if (not isNull player) then {
     hudTask={
	  private ["_res","_c","_d"];
	  waituntil {gameStarted} ;

	  waitUntil {not isNil "theFlag"; };
	  [10] call hudInit ;
	  [theFlag] call createFlagHinter ;
	  while {gameState=="playing"} do {
	       _res = [] call findWinners ;
	       [0,format ["Flag: %1",[theFlag] call flagText]] call hudSetLine ;
	       [1,format ["Leaders: %1 pts",_res select 1]] call hudSetLine ;
	       _c = 0;
	       { 
		    [2+_c,format ["  %1",_x]] call hudSetLine ;
		    _c = _c +1 ;
	       } foreach (_res select 0);
	       for "_d" from _c to 7 do {
		    [2+_d,""] call hudSetLine ;
	       } ;
	       [-2,format ["YOU: %1 pts",score player]] call hudSetLine ;
	       [-1,[] call TimeLeftString] call hudSetLine ;
	       scoreHint = [] call hudStringify ;
	       sleep 1 ;
	  } ;
	  call hudHide ;
     } ;
};
     
     

