// BAS f - setAISkillAD (Attack & Defend Version)
// Version: 0-0-3 (2007-05-21)
// Author(s): Fer | Raedor
// ====================================================================================

// JIP CHECK
// Prevents the script executing until the player has synchronised correctly:

#include "f_waitForJIP.sqf"

// ====================================================================================

// DECLARE VARIABLES AND FUNCTIONS

private ["_units","_localUnits","_localBLUUnits","_localRESUnits","_localOPFUnits","_localCIVUnits","_strMen","_strLocalUnits","_strLocalBLUUnits","_strLocalRESUnits","_strLocalOPFUnits","_strLocalCIVUnits","_superSkill","_highSkill","_mediumSkill","_lowSkill","_skillSideBLUFOR","_skillSideOPFOR"];

// ====================================================================================

// WAIT FOR COMMON VARIABLES TO BE SET
// Before executing this script, we wait for the script 'f_setCommonVars.sqf' to run:

waitUntil {scriptDone f_script_setLocalVars};

// ====================================================================================

// SET KEY VARIABLES
// AI Skills are set using the value of f_var_Param2. Usually, f_var_Param2 == Param2.

f_var_Param2 = Param2;
_superSkill = 1.00;
_highSkill = 0.75;
_mediumSkill = 0.50;
_lowSkill = 0.25;

// Using a common variable, we will create an array containing all men.

_units = f_var_units;

// We split out the contents of _units - first by locality, then by side.

_localUnits = [];
_localBLUUnits = [];
_localRESUnits = [];
_localOPFUnits = [];
_localCIVUnits = [];

{if (local _x) then {_localUnits = _localUnits + [_x]}} forEach _units;
{if ((side _x) == west) then {_localBLUUnits = _localBLUUnits + [_x]}} forEach _localUnits;
{if ((side _x) == resistance) then {_localRESUnits = _localRESUnits + [_x]}} forEach _localUnits;
{if ((side _x) == east) then {_localOPFUnits = _localOPFUnits + [_x]}} forEach _localUnits;
{if ((side _x) == civilian) then {_localCIVUnits = _localCIVUnits + [_x]}} forEach _localUnits;

// DEBUG
if (f_var_debugMode == 1) then
{
	_strUnits = str _units;
	_strLocalUnits = str _localUnits;
	_strLocalBLUUnits = str _localBLUUnits;
	_strLocalRESUnits = str _localRESUnits;
	_strLocalOPFUnits = str _localOPFUnits;
	_strLocalCIVUnits = str _localCIVUnits;
	player sideChat format ["DEBUG (f\common\f_setAISkillAD.sqf): _units = %1",_strUnits];
	player sideChat format ["DEBUG (f\common\f_setAISkillAD.sqf): _localUnits = %1",_strLocalUnits];
	player sideChat format ["DEBUG (f\common\f_setAISkillAD.sqf): _localBLUUnits = %1",_strLocalBLUUnits];
	player sideChat format ["DEBUG (f\common\f_setAISkillAD.sqf): _localRESUnits = %1",_strLocalRESUnits];
	player sideChat format ["DEBUG (f\common\f_setAISkillAD.sqf): _localOPFUnits = %1",_strLocalOPFUnits];
	player sideChat format ["DEBUG (f\common\f_setAISkillAD.sqf): _localCIVUnits = %1",_strLocalCIVUnits];
};

// ====================================================================================

// SELECT FRIENDLY AND ENEMY AI SKILLS
// Using the value of f_var_Param2, values for _skillSideBLUFOR and _skillSideOPFOR are set.

switch (f_var_Param2) do
{
// Random | Random
	case 1:
	{
	};
// Random | Super
	case 2:
	{
	};
// Random | High
	case 3:
	{
	};
// Random | Medium
	case 4:
	{
	};
// Random | Low
	case 5:
	{
	};
// Super | Super
	case 6:
	{
		_skillSideBLUFOR = _superSkill;
		_skillSideOPFOR = _superSkill;
	};
// Super | High
	case 7:
	{
		_skillSideBLUFOR = _superSkill;
		_skillSideOPFOR = _highSkill;
	};
// Super | Medium
	case 8:
	{
		_skillSideBLUFOR = _superSkill;
		_skillSideOPFOR = _mediumSkill;
	};
// Super | Low
	case 9:
	{
		_skillSideBLUFOR = _superSkill;
		_skillSideOPFOR = _lowSkill;
	};
// High | Random
	case 10:
	{
	};
// High | Super
	case 11:
	{
		_skillSideBLUFOR = _highSkill;
		_skillSideOPFOR = _superSkill;
	};
// High | High
	case 12:
	{
		_skillSideBLUFOR = _highSkill;
		_skillSideOPFOR = _highSkill;
	};
// High | Medium
	case 13:
	{
		_skillSideBLUFOR = _highSkill;
		_skillSideOPFOR = _mediumSkill;
	};
// High | Low
	case 14:
	{
		_skillSideBLUFOR = _highSkill;
		_skillSideOPFOR = _lowSkill;
	};
// Medium | Random
	case 15:
	{
	};
// Medium | Super
	case 16:
	{
		_skillSideBLUFOR = _mediumSkill;
		_skillSideOPFOR = _superSkill;
	};
// Medium | High
	case 17:
	{
		_skillSideBLUFOR = _mediumSkill;
		_skillSideOPFOR = _highSkill;
	};
// Medium | Medium
	case 18:
	{
		_skillSideBLUFOR = _mediumSkill;
		_skillSideOPFOR = _mediumSkill;
	};
// Medium | Low
	case 19:
	{
		_skillSideBLUFOR = _mediumSkill;
		_skillSideOPFOR = _lowSkill;
	};
// Low | Random
	case 20:
	{
	};
// Low | Super
	case 21:
	{
		_skillSideBLUFOR = _lowSkill;
		_skillSideOPFOR = _superSkill;
	};
// Low | High
	case 22:
	{
		_skillSideBLUFOR = _lowSkill;
		_skillSideOPFOR = _highSkill;
	};
// Low | Medium
	case 23:
	{
		_skillSideBLUFOR = _lowSkill;
		_skillSideOPFOR = _mediumSkill;
	};
// Low | Low
	case 24:
	{
		_skillSideBLUFOR = _lowSkill;
		_skillSideOPFOR = _lowSkill;
	};
// Debug Mode
	case 99:
	{
		_skillSideBLUFOR = _lowSkill;
		_skillSideOPFOR = _lowSkill;
	};
};

// ====================================================================================

// SET SIDE AI SKILL LEVELS
// AI Skill for each side is set (in part using variables from the init.sqf file).

f_skillBLU = _skillSideBLUFOR;
if (f_isFriendlyToBLU_RES == 1) then {f_skillRES = _skillSideBLUFOR} else {f_skillRES = _skillSideOPFOR};
f_skillOPF = _skillSideOPFOR;
if (f_isFriendlyToBLU_CIV == 1) then {f_skillCIV = _skillSideBLUFOR} else {f_skillCIV = _skillSideOPFOR};

// DEBUG
if (f_var_debugMode == 1) then
{
	_strSkillSideBLUFOR = str _skillSideBLUFOR;
	_strSkillSideOPFOR = str _skillSideOPFOR;
	player sideChat format ["DEBUG (f\common\f_setAISkillAD.sqf): _skillSideBLUFOR = %1",_strSkillSideBLUFOR];
	player sideChat format ["DEBUG (f\common\f_setAISkillAD.sqf): _skillSideOPFOR = %1",_strSkillSideOPFOR];
	player sideChat format ["DEBUG (f\common\f_setAISkillAD.sqf): f_skillBLU = %1",f_skillBLU];
	player sideChat format ["DEBUG (f\common\f_setAISkillAD.sqf): f_skillRES = %1",f_skillRES];
	player sideChat format ["DEBUG (f\common\f_setAISkillAD.sqf): f_skillOPF = %1",f_skillOPF];
	player sideChat format ["DEBUG (f\common\f_setAISkillAD.sqf): f_skillCIV = %1",f_skillCIV];
};

// ====================================================================================

// SET SKILL LEVELS FOR ALL LOCAL AI
// AI Skill for all local AIs is set using side levels (see above).

{_x setSkill f_skillBLU} forEach _localBLUUnits;
{_x setSkill f_skillRES} forEach _localRESUnits;
{_x setSkill f_skillOPF} forEach _localOPFUnits;
{_x setSkill f_skillCIV} forEach _localCIVUnits;

// DEBUG (SPECIAL)
// if (f_var_debugMode == 1) then
// {
// 	{_x addEventHandler ["hit", {_v=_this select 0; _skillV = skill _v; player sideChat format ["DEBUG (f\common\f_setAISkillAD.sqf): Skill %1 = %2",_v,_skillV]}];} forEach _localUnits;
// };

// ====================================================================================

if (true) exitWith {};
